/*
 * Decompiled with CFR 0.152.
 */
package ej.restserver;

import ej.hoka.http.HTTPServer;
import ej.hoka.http.HTTPSession;
import ej.restserver.EndpointHandler;
import ej.restserver.RequestHandler;
import ej.restserver.RestEndpoint;
import ej.restserver.RestSession;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ServerSocketFactory;

public class RestServer
extends HTTPServer {
    private final List<RestEndpoint> endpoints = new LinkedList<RestEndpoint>();
    private final List<RequestHandler> requestHandlers = new LinkedList<RequestHandler>();

    public RestServer(int port, int maxSimultaneousConnection, int jobCountBySession) throws IOException {
        super(port, maxSimultaneousConnection, jobCountBySession, (HTTPSession.Factory)new RestSession.Factory());
        this.requestHandlers.add(new EndpointHandler());
    }

    public RestServer(int port, int maxSimultaneousConnection, int jobCountBySession, ServerSocketFactory serverSocketFactory) throws IOException {
        super(port, maxSimultaneousConnection, jobCountBySession, (HTTPSession.Factory)new RestSession.Factory(), serverSocketFactory);
        this.requestHandlers.add(new EndpointHandler());
    }

    public void addEndpoint(RestEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public void addRequestResolver(RequestHandler handler) {
        this.requestHandlers.add(handler);
    }

    public List<RestEndpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    public List<RequestHandler> getRequestResolvers() {
        return Collections.unmodifiableList(this.requestHandlers);
    }
}

