/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget.display.buffer;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import ej.fp.widget.display.DisplayBufferManager;
import ej.fp.widget.display.buffer.DisplayBufferPolicy;
import ej.microui.display.Rectangle;

public class SingleBufferPolicy
implements DisplayBufferPolicy {
    private Widget displayWidget;
    private Image backBuffer;
    private Image frontBuffer;

    @Override
    public void setDisplayProperties(Widget displayWidget, int width, int height, int initialColor) {
        this.displayWidget = displayWidget;
        this.backBuffer = FrontPanel.getFrontPanel().newImage(width, height, initialColor, false);
        this.frontBuffer = FrontPanel.getFrontPanel().newImage(width, height, initialColor, false);
    }

    @Override
    public int getBufferCount() {
        return 1;
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    @Override
    public void flush(DisplayBufferManager bufferManager, Rectangle[] rectangles) {
        Rectangle[] rectangleArray = rectangles;
        int n = rectangles.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray[n2];
            this.frontBuffer.drawImage(this.backBuffer, rectangle.getX1(), rectangle.getY1(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getX1(), rectangle.getY1(), rectangle.getWidth(), rectangle.getHeight());
            ++n2;
        }
        this.displayWidget.repaint();
        bufferManager.simulateFlushTime();
    }

    @Override
    public Image getBackBuffer() {
        return this.backBuffer;
    }

    @Override
    public Image getFrontBuffer() {
        return this.frontBuffer;
    }

    @Override
    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(new Image[]{this.backBuffer, this.frontBuffer});
    }
}

