/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget.display.brs;

import ej.fp.widget.display.DisplayBufferManager;
import ej.fp.widget.display.brs.BufferRefreshStrategy;
import ej.microui.display.Rectangle;

public class LegacyRefreshStrategy
implements BufferRefreshStrategy {
    private Rectangle[] dirtyRectangles;
    private int currentDirtyRectangle;

    @Override
    public void setDisplaySize(int width, int height) {
    }

    @Override
    public void setBufferCount(int bufferCount) {
        int count = Math.max(bufferCount - 1, 1);
        this.dirtyRectangles = new Rectangle[count];
        int i = 0;
        while (i < count) {
            this.dirtyRectangles[i] = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
            ++i;
        }
    }

    @Override
    public void newDrawingRegion(DisplayBufferManager bufferManager, Rectangle rectangle, boolean drawingNow) {
        this.updateBoundingBox(rectangle);
    }

    private void updateBoundingBox(Rectangle rectangle) {
        int x1 = rectangle.getX1();
        int x2 = rectangle.getX2();
        int y1 = rectangle.getY1();
        int y2 = rectangle.getY2();
        int i = 0;
        while (i < this.dirtyRectangles.length) {
            Rectangle dirtyRectangle = this.dirtyRectangles[i];
            dirtyRectangle.setX1(Math.min(dirtyRectangle.getX1(), x1));
            dirtyRectangle.setY1(Math.min(dirtyRectangle.getY1(), y1));
            dirtyRectangle.setX2(Math.max(dirtyRectangle.getX2(), x2));
            dirtyRectangle.setY2(Math.max(dirtyRectangle.getY2(), y2));
            ++i;
        }
    }

    @Override
    public void refresh(DisplayBufferManager bufferManager) {
        Rectangle dirtyRectangleBuffer = this.dirtyRectangles[this.currentDirtyRectangle];
        bufferManager.flush(new Rectangle[]{new Rectangle(dirtyRectangleBuffer)});
        bufferManager.restore(dirtyRectangleBuffer);
        this.initializeBoundingBox(dirtyRectangleBuffer);
        this.currentDirtyRectangle = (this.currentDirtyRectangle + 1) % this.dirtyRectangles.length;
    }

    private void initializeBoundingBox(Rectangle rectangle) {
        rectangle.setX1(Integer.MAX_VALUE);
        rectangle.setY1(Integer.MAX_VALUE);
        rectangle.setX2(Integer.MIN_VALUE);
        rectangle.setY2(Integer.MIN_VALUE);
    }
}

