/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.MouseListener;
import ej.fp.Widget;
import ej.fp.util.ThirdEventThread;
import ej.fp.util.WidgetWithListener;
import ej.microui.event.EventCommand;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label", isOptional=true), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="skin"), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="upSkin"), @Widget.WidgetAttribute(name="downSkin"), @Widget.WidgetAttribute(name="leftSkin"), @Widget.WidgetAttribute(name="rightSkin"), @Widget.WidgetAttribute(name="enterSkin", isOptional=true), @Widget.WidgetAttribute(name="disableEnter", isOptional=true), @Widget.WidgetAttribute(name="repeatPeriod", isOptional=true), @Widget.WidgetAttribute(name="listenerClass", isOptional=true)})
public class Joystick
extends WidgetWithListener
implements MouseListener,
ThirdEventThread.ThirdEventWidget {
    private final ThirdEventThread repeatThread;
    private final JoystickButton up = new Up();
    private final JoystickButton down = new Down();
    private final JoystickButton left = new Left();
    private final JoystickButton right = new Right();
    private final JoystickButton enter = new Enter();
    private JoystickListener listener;
    private int centerX;
    private int centerY;
    private int period = 200;
    private boolean disableEnter;

    public Joystick() {
        this.repeatThread = new ThirdEventThread(this, true);
    }

    public void setUpSkin(Image skin) {
        this.up.skin = skin;
    }

    public void setDownSkin(Image skin) {
        this.down.skin = skin;
    }

    public void setLeftSkin(Image skin) {
        this.left.skin = skin;
    }

    public void setRightSkin(Image skin) {
        this.right.skin = skin;
    }

    public void setEnterSkin(Image skin) {
        this.enter.skin = skin;
    }

    public void setRepeatPeriod(int period) {
        if (period <= 20) {
            throw new IllegalArgumentException("Joystick period cannot be smaller than 20ms.");
        }
        this.period = period;
    }

    public void setDisableEnter(boolean disableEnter) {
        this.disableEnter = disableEnter;
    }

    public void setListenerClass(String listenerClassName) {
        this.setListenerClass(JoystickListener.class, listenerClassName);
    }

    public synchronized void finalizeConfiguration() {
        super.finalizeConfiguration();
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
    }

    public void start() {
        super.start();
        this.listener = this.newListener(JoystickListener.class);
        this.repeatThread.start();
    }

    public void dispose() {
        this.repeatThread.dispose();
        this.up.dispose();
        this.down.dispose();
        this.left.dispose();
        this.right.dispose();
        this.enter.dispose();
        super.dispose();
    }

    @Override
    protected Object newDefaultListener() {
        return new JoystickListenerToCommandEvents();
    }

    @Override
    public void sendThirdEvent() {
        if (!this.enter.sendRepeat(this)) {
            this.up.sendRepeat(this);
            this.down.sendRepeat(this);
            this.left.sendRepeat(this);
            this.right.sendRepeat(this);
        }
    }

    @Override
    public int getSleepPeriod() {
        return 20;
    }

    public void mousePressed(int x, int y, MouseListener.MouseButton button) {
        if (button == MouseListener.MouseButton.FIRST_BUTTON) {
            boolean mouseUp;
            int relativeX = this.centerX - x;
            int relativeY = this.centerY - y;
            boolean mouseEquals = relativeX == relativeY || relativeX == -relativeY;
            boolean mouseRight = relativeX < 0 && relativeY < -relativeX && relativeY > relativeX;
            boolean mouseLeft = relativeX > 0 && relativeY < relativeX && relativeY > -relativeX;
            boolean mouseDown = relativeY < 0 && relativeX < -relativeY && relativeX > relativeY;
            boolean bl = mouseUp = relativeY > 0 && relativeX < relativeY && relativeX > -relativeY;
            if (!mouseEquals) {
                if (mouseRight) {
                    this.right.sendPress(this);
                } else if (mouseLeft) {
                    this.left.sendPress(this);
                } else if (mouseUp) {
                    this.up.sendPress(this);
                } else if (mouseDown) {
                    this.down.sendPress(this);
                }
                this.launchThread();
            }
        } else if (button == MouseListener.MouseButton.THIRD_BUTTON && !this.disableEnter) {
            this.enter.sendPress(this);
            this.launchThread();
        }
    }

    public void mouseReleased(int x, int y, MouseListener.MouseButton button) {
        if (button == MouseListener.MouseButton.FIRST_BUTTON) {
            this.up.sendRelease(this);
            this.down.sendRelease(this);
            this.left.sendRelease(this);
            this.right.sendRelease(this);
        } else if (button == MouseListener.MouseButton.THIRD_BUTTON && !this.disableEnter) {
            this.enter.sendRelease(this);
        }
        if (!(this.up.sendThirdEvent || this.down.sendThirdEvent || this.left.sendThirdEvent || this.right.sendThirdEvent || this.enter.sendThirdEvent)) {
            this.stopThread();
        }
    }

    private void launchThread() {
        this.repeatThread.wakeup();
    }

    private void stopThread() {
        this.repeatThread.goToSleep();
    }

    private static class Down
    extends JoystickButton {
        private Down() {
        }

        @Override
        void press(Joystick joystick) {
            joystick.listener.pressDown(joystick);
        }

        @Override
        void repeat(Joystick joystick) {
            joystick.listener.repeatDown(joystick);
        }

        @Override
        void release(Joystick joystick) {
            joystick.listener.releaseDown(joystick);
        }
    }

    private static class Enter
    extends JoystickButton {
        private Enter() {
        }

        @Override
        void press(Joystick joystick) {
            joystick.listener.pressEnter(joystick);
        }

        @Override
        void repeat(Joystick joystick) {
            joystick.listener.repeatEnter(joystick);
        }

        @Override
        void release(Joystick joystick) {
            joystick.listener.releaseEnter(joystick);
        }
    }

    private static abstract class JoystickButton {
        private Image skin;
        private boolean sendThirdEvent;
        private long time;

        private JoystickButton() {
        }

        abstract void press(Joystick var1);

        abstract void repeat(Joystick var1);

        abstract void release(Joystick var1);

        private void sendPress(Joystick joystick) {
            this.sendThirdEvent = true;
            this.time = System.currentTimeMillis();
            if (this.skin != null) {
                joystick.setCurrentSkin(this.skin);
            }
            this.press(joystick);
        }

        private boolean sendRepeat(Joystick joystick) {
            if (this.sendThirdEvent && System.currentTimeMillis() - this.time >= (long)joystick.period) {
                this.time = System.currentTimeMillis();
                this.repeat(joystick);
                return true;
            }
            return false;
        }

        private void sendRelease(Joystick joystick) {
            if (this.sendThirdEvent) {
                this.sendThirdEvent = false;
                this.release(joystick);
                joystick.setCurrentSkin(joystick.getSkin());
            }
        }

        private void dispose() {
            FrontPanel.getFrontPanel().disposeIfNotNull(new Image[]{this.skin});
        }
    }

    public static interface JoystickListener {
        public void pressUp(Joystick var1);

        public void pressDown(Joystick var1);

        public void pressLeft(Joystick var1);

        public void pressRight(Joystick var1);

        public void pressEnter(Joystick var1);

        public void repeatUp(Joystick var1);

        public void repeatDown(Joystick var1);

        public void repeatLeft(Joystick var1);

        public void repeatRight(Joystick var1);

        public void repeatEnter(Joystick var1);

        public void releaseUp(Joystick var1);

        public void releaseDown(Joystick var1);

        public void releaseLeft(Joystick var1);

        public void releaseRight(Joystick var1);

        public void releaseEnter(Joystick var1);
    }

    public static class JoystickListenerToCommandEvents
    implements JoystickListener {
        @Override
        public void pressDown(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)3);
        }

        @Override
        public void pressEnter(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)6);
        }

        @Override
        public void pressLeft(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)4);
        }

        @Override
        public void pressRight(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)5);
        }

        @Override
        public void pressUp(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)2);
        }

        @Override
        public void releaseDown(Joystick widget) {
        }

        @Override
        public void releaseEnter(Joystick widget) {
        }

        @Override
        public void releaseLeft(Joystick widget) {
        }

        @Override
        public void releaseRight(Joystick widget) {
        }

        @Override
        public void releaseUp(Joystick widget) {
        }

        @Override
        public void repeatDown(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)3);
        }

        @Override
        public void repeatEnter(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)6);
        }

        @Override
        public void repeatLeft(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)4);
        }

        @Override
        public void repeatRight(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)5);
        }

        @Override
        public void repeatUp(Joystick widget) {
            EventCommand.sendEvent((String)this.getMicroUIGeneratorTag(), (int)2);
        }

        protected String getMicroUIGeneratorTag() {
            return "COMMANDS";
        }
    }

    private static class Left
    extends JoystickButton {
        private Left() {
        }

        @Override
        void press(Joystick joystick) {
            joystick.listener.pressLeft(joystick);
        }

        @Override
        void repeat(Joystick joystick) {
            joystick.listener.repeatLeft(joystick);
        }

        @Override
        void release(Joystick joystick) {
            joystick.listener.releaseLeft(joystick);
        }
    }

    private static class Right
    extends JoystickButton {
        private Right() {
        }

        @Override
        void press(Joystick joystick) {
            joystick.listener.pressRight(joystick);
        }

        @Override
        void repeat(Joystick joystick) {
            joystick.listener.repeatRight(joystick);
        }

        @Override
        void release(Joystick joystick) {
            joystick.listener.releaseRight(joystick);
        }
    }

    private static class Up
    extends JoystickButton {
        private Up() {
        }

        @Override
        void press(Joystick joystick) {
            joystick.listener.pressUp(joystick);
        }

        @Override
        void repeat(Joystick joystick) {
            joystick.listener.repeatUp(joystick);
        }

        @Override
        void release(Joystick joystick) {
            joystick.listener.releaseUp(joystick);
        }
    }
}

