/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.event;

import ej.annotation.Nullable;
import ej.microui.event.Event;
import ej.microui.event.generator.Buttons;
import ej.microui.event.generator.Pointer;
import ej.mwt.Desktop;
import ej.mwt.Widget;
import ej.mwt.event.DesktopEventGenerator;
import ej.mwt.event.EventDispatcher;

public class PointerEventDispatcher
extends EventDispatcher {
    public static final int EXITED = 0;
    @Nullable
    private DesktopEventGenerator eventGenerator;
    @Nullable
    private Widget pressedHierarchyLeaf;
    @Nullable
    private Widget consumerWidget;

    public PointerEventDispatcher(Desktop desktop) {
        super(desktop);
    }

    @Override
    public void initialize() {
        DesktopEventGenerator eventGenerator = this.createEventGenerator();
        eventGenerator.addToSystemPool();
        this.eventGenerator = eventGenerator;
    }

    @Override
    public void dispose() {
        DesktopEventGenerator eventGenerator = this.eventGenerator;
        if (eventGenerator != null) {
            eventGenerator.removeFromSystemPool();
            this.eventGenerator = null;
        }
        this.pressedHierarchyLeaf = null;
        this.consumerWidget = null;
    }

    @Nullable
    public Widget getPressedHierarchyLeaf() {
        return this.pressedHierarchyLeaf;
    }

    @Nullable
    public Widget getConsumerWidget() {
        return this.consumerWidget;
    }

    protected DesktopEventGenerator createEventGenerator() {
        return new DesktopEventGenerator();
    }

    @Nullable
    protected DesktopEventGenerator getEventGenerator() {
        return this.eventGenerator;
    }

    private int buildExitEvent() {
        DesktopEventGenerator eventGenerator = this.eventGenerator;
        assert (eventGenerator != null);
        return eventGenerator.buildEvent(0);
    }

    @Override
    public boolean dispatchEvent(int event) {
        int type = Event.getType((int)event);
        if (type == 2) {
            this.pointerEvent(event);
            return true;
        }
        return false;
    }

    private void pointerEvent(int event) {
        Pointer pointer = (Pointer)Event.getGenerator((int)event);
        int action = Buttons.getAction((int)event);
        switch (action) {
            case 0: {
                this.pressed(event, pointer);
                break;
            }
            case 7: {
                this.dragged(event, pointer);
                break;
            }
            case 1: {
                this.released(event, pointer);
            }
        }
    }

    private void pressed(int event, Pointer pointer) {
        this.updatePointerPress(pointer);
        this.dispatchEvent(event, true, false);
    }

    private void dragged(int event, Pointer pointer) {
        this.updatePointerDrag(pointer);
        this.dispatchEvent(event, true, true);
    }

    private void released(int event, Pointer pointer) {
        this.updatePointerDrag(pointer);
        this.dispatchEvent(event, false, true);
        this.consumerWidget = null;
        this.pressedHierarchyLeaf = null;
    }

    private void updatePointerPress(Pointer pointer) {
        int x = pointer.getX();
        int y = pointer.getY();
        Widget widget = this.getDesktop().getWidgetAt(x, y);
        while (widget != null && !widget.isEnabled()) {
            widget = widget.getParent();
        }
        this.pressedHierarchyLeaf = widget;
        this.consumerWidget = null;
    }

    private void updatePointerDrag(Pointer pointer) {
        int x = pointer.getX();
        int y = pointer.getY();
        Widget oldPressedHierarchyLeaf = this.pressedHierarchyLeaf;
        if (oldPressedHierarchyLeaf == null) {
            return;
        }
        Desktop desktop = this.getDesktop();
        if (!desktop.containsWidget(oldPressedHierarchyLeaf)) {
            this.consumerWidget = null;
            this.pressedHierarchyLeaf = null;
            return;
        }
        Widget widget = desktop.getWidgetAt(x, y);
        while (!(widget == null || widget.isEnabled() && widget.containsWidget(oldPressedHierarchyLeaf))) {
            widget = widget.getParent();
        }
        if (widget == oldPressedHierarchyLeaf) {
            return;
        }
        Widget consumerWidget = this.consumerWidget;
        if (consumerWidget != null) {
            this.sendEventToWidget(consumerWidget, this.buildExitEvent());
            this.consumerWidget = null;
            this.pressedHierarchyLeaf = null;
        } else {
            this.sendEventToLimitedWidgetHierarchy(oldPressedHierarchyLeaf, widget, this.buildExitEvent());
            this.pressedHierarchyLeaf = widget;
        }
    }

    private void dispatchEvent(int event, boolean exitOffsprings, boolean exitAncestors) {
        Widget consumerWidget = this.consumerWidget;
        if (consumerWidget != null) {
            this.sendEventToWidget(consumerWidget, event);
        } else {
            Widget pressedHierarchyLeaf = this.pressedHierarchyLeaf;
            if (pressedHierarchyLeaf != null && (consumerWidget = this.sendEventToWidgetHierarchy(pressedHierarchyLeaf, event)) != null) {
                int exitEvent = this.buildExitEvent();
                if (exitOffsprings) {
                    this.sendEventToLimitedWidgetHierarchy(pressedHierarchyLeaf, consumerWidget, exitEvent);
                }
                if (exitAncestors) {
                    this.sendEventToLimitedWidgetHierarchy(consumerWidget.getParent(), null, exitEvent);
                }
                this.consumerWidget = consumerWidget;
                this.pressedHierarchyLeaf = consumerWidget;
            }
        }
    }

    private void sendEventToLimitedWidgetHierarchy(@Nullable Widget oldHierarchyLeaf, @Nullable Widget newHierarchyLeaf, int event) {
        Widget widget = oldHierarchyLeaf;
        while (widget != null) {
            if (widget == newHierarchyLeaf) {
                return;
            }
            this.sendEventToWidget(widget, event);
            widget = widget.getParent();
        }
    }

    public static final boolean isExited(int event) {
        return Event.getType((int)event) == 4 && DesktopEventGenerator.getAction(event) == 0;
    }
}

