/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.serversocket;

import ej.rcommand.impl.StreamRemoteConnection;
import ej.rcommand.serversocket.RemoteCommandServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketRemoteConnection
extends StreamRemoteConnection {
    private static final String BUFFER_SIZE_PROPERTY = "rcommand.serversocket.buffer.size";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final RemoteCommandServer adminServer;
    private final Socket socket;
    private boolean closed;

    public SocketRemoteConnection(Socket socket, RemoteCommandServer adminServer) throws IOException {
        super((InputStream)new BufferedInputStream(socket.getInputStream(), SocketRemoteConnection.getBufferSize()), (OutputStream)new BufferedOutputStream(socket.getOutputStream(), SocketRemoteConnection.getBufferSize()));
        this.socket = socket;
        this.adminServer = adminServer;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.adminServer.releaseConnection();
            super.close();
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static int getBufferSize() {
        return Integer.getInteger(BUFFER_SIZE_PROPERTY, 8192);
    }
}

