/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.serversocket;

import ej.rcommand.RemoteCommandManager;
import ej.rcommand.RemoteConnection;
import ej.rcommand.connectivity.ConnectivityListener;
import ej.rcommand.connectivity.ConnectivityManager;
import ej.rcommand.serversocket.SocketRemoteConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;

public class RemoteCommandServer
implements Runnable,
ConnectivityManager {
    private final Logger logger = Logger.getLogger(RemoteCommandServer.class.getSimpleName());
    private final int port;
    private int nbConnections;
    private final int nbMaxConnections;
    private final Object monitor;
    private volatile boolean running;
    private final RemoteCommandManager commandManager;
    private ServerSocket serverSocket;
    private final List<ConnectivityListener> listeners;

    public RemoteCommandServer(RemoteCommandManager commandManager, int port, int nbMaxConnection) {
        this.port = port;
        this.nbMaxConnections = nbMaxConnection;
        this.nbConnections = 0;
        this.commandManager = commandManager;
        this.monitor = new Object();
        this.listeners = new ArrayList<ConnectivityListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        int delay = 250;
        do {
            boolean networkAvailable = false;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ServerSocket serverSocket = new ServerSocket();){
                    serverSocket.setReuseAddress(true);
                    serverSocket.bind(new InetSocketAddress(null, this.port));
                    networkAvailable = true;
                    delay = 0;
                    this.serverSocket = serverSocket;
                    this.logger.info("Server listening on port " + this.port);
                    while (this.running) {
                        Object object = this.monitor;
                        synchronized (object) {
                            while (this.nbConnections == this.nbMaxConnections) {
                                this.monitor.wait();
                            }
                        }
                        Socket client = serverSocket.accept();
                        SocketRemoteConnection remoteConnection = new SocketRemoteConnection(client, this);
                        this.commandManager.startReading((RemoteConnection)remoteConnection, "Admin " + client.getRemoteSocketAddress());
                        ++this.nbConnections;
                        this.notifyConnectivityListener(true);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            if (!this.running || networkAvailable) continue;
            try {
                this.logger.fine("Waiting for " + delay + " ms for the network.");
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.interrupted();
                return;
            }
            if (delay >= 10000) continue;
            delay *= 2;
        } while (this.running);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stopRunning() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        var1_1 = this.monitor;
        synchronized (var1_1) {
            this.monitor.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl14
        }
        do {
            --this.nbConnections;
            this.notifyConnectivityListener(false);
lbl14:
            // 2 sources

        } while (this.nbConnections > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection() {
        Object object = this.monitor;
        synchronized (object) {
            --this.nbConnections;
            this.monitor.notify();
        }
        this.notifyConnectivityListener(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() {
        Object object = this.monitor;
        synchronized (object) {
            return this.nbConnections;
        }
    }

    public String getConnectionInfo() {
        if (this.serverSocket != null) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces != null) {
                    StringBuffer info = new StringBuffer();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface iface = interfaces.nextElement();
                        if (iface.isLoopback() || !iface.isUp()) continue;
                        Enumeration<InetAddress> addresses = iface.getInetAddresses();
                        int n = 0;
                        while (addresses.hasMoreElements()) {
                            if (n++ == 1) {
                                info.append(',');
                            }
                            info.append(addresses.nextElement().getHostAddress());
                        }
                        info.append(':').append(this.port);
                        return info.toString();
                    }
                }
            }
            catch (SocketException socketException) {}
        }
        return null;
    }

    private synchronized void notifyConnectivityListener(boolean connect) {
        if (connect) {
            for (ConnectivityListener listener : this.listeners) {
                listener.onConnect();
            }
        } else {
            for (ConnectivityListener listener : this.listeners) {
                listener.onDisconnect();
            }
        }
    }

    public synchronized void addConnectivityListener(ConnectivityListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeConnectivityListener(ConnectivityListener listener) {
        this.listeners.remove(listener);
    }
}

