/*
 * Decompiled with CFR 0.152.
 */
package ej.junit;

import ej.junit.TestListener;
import ej.junit.TestWrapper;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assume;

public abstract class AbstractTestWrapper
implements TestWrapper {
    protected final Class<?> testClass;
    protected final String testClassName;
    protected boolean failed = false;
    protected String testMethod;
    protected long testMethodStart;
    protected Object test;
    int runs;
    int failures;
    int errors;
    protected TestListener testListener;

    public AbstractTestWrapper(Class<?> testClass) {
        this.testClass = testClass;
        this.testClassName = testClass.getName();
    }

    protected void reportError(Throwable error) {
        ++this.errors;
        if (this.testListener != null) {
            ByteArrayOutputStream stackStream = new ByteArrayOutputStream();
            error.printStackTrace(new PrintStream(stackStream));
            this.testListener.onError(error.getMessage(), error.getClass().getName(), stackStream.toString());
        }
    }

    protected void reportFailure(AssertionError error) {
        ++this.failures;
        if (this.testListener != null) {
            ByteArrayOutputStream stackStream = new ByteArrayOutputStream();
            ((Throwable)((Object)error)).printStackTrace(new PrintStream(stackStream));
            this.testListener.onFailure(((Throwable)((Object)error)).getMessage(), error.getClass().getName(), stackStream.toString());
        }
    }

    protected void reportSkip(String message) {
        if (this.testListener != null) {
            this.testListener.onSkip(message);
        }
    }

    protected void reportTestEnd() {
        if (this.testListener != null) {
            double duration = (double)(System.currentTimeMillis() - this.testMethodStart) / 1000.0;
            this.testListener.onCaseEnd(this.testMethod, duration);
        }
    }

    protected abstract void runBeforeClassMethods() throws Exception;

    protected abstract void runAfterClassMethods() throws Exception;

    protected abstract void runBeforeMethods() throws Exception;

    protected abstract void runAfterMethods() throws Exception;

    protected abstract void runTestMethods();

    boolean wrapperRunBeforeClassMethod() {
        try {
            this.testMethod = null;
            this.runBeforeClassMethods();
            return true;
        }
        catch (Throwable t) {
            this.reportError(t);
            return false;
        }
    }

    void wrapperRunAfterClassMethod() {
        try {
            this.testMethod = null;
            this.runAfterClassMethods();
        }
        catch (Throwable t) {
            this.reportError(t);
        }
    }

    protected final boolean testInitialize(String testMethodName) {
        try {
            ++this.runs;
            if (this.testListener != null) {
                this.testListener.testInstance(this.testClass.getName());
            }
            this.test = this.testClass.newInstance();
            this.testMethod = testMethodName;
            this.runBeforeMethods();
            this.testMethodStart = System.currentTimeMillis();
            if (this.testListener != null) {
                this.testListener.onCaseStart(testMethodName, this.testClassName, "FILE", 0);
            }
        }
        catch (Throwable t) {
            this.reportError(t);
            return false;
        }
        String property = "tests." + this.testClass.getSimpleName() + "." + testMethodName + ".skip";
        Assume.assumeFalse(String.valueOf(property) + " skips this test", Boolean.getBoolean(property));
        return true;
    }

    protected final void testFinalize() {
        try {
            try {
                if (this.test != null) {
                    this.runAfterMethods();
                }
            }
            catch (Throwable t) {
                this.reportError(t);
                if (this.test != null) {
                    this.reportTestEnd();
                }
                this.testMethod = null;
            }
        }
        finally {
            if (this.test != null) {
                this.reportTestEnd();
            }
            this.testMethod = null;
        }
    }

    private synchronized void wrapperRunTestMethods() {
        try {
            try {
                boolean ok = this.wrapperRunBeforeClassMethod();
                if (ok) {
                    this.runTestMethods();
                }
            }
            finally {
                this.wrapperRunAfterClassMethod();
            }
        }
        catch (Throwable t) {
            this.reportError(t);
        }
    }

    @Override
    public String getTestClass() {
        return this.testClassName;
    }

    @Override
    public synchronized boolean run(TestListener listener) {
        this.failures = 0;
        this.errors = 0;
        this.testListener = listener;
        if (this.testListener != null) {
            this.testListener.onSuiteStart(this.testClassName);
        }
        this.wrapperRunTestMethods();
        if (this.testListener != null) {
            this.testListener.onSuiteEnd(this.testClassName, this.runs, this.failures, this.errors);
        }
        return this.errors == 0 && this.failures == 0;
    }
}

