/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.encoding;

import ej.basictool.map.PackedMap;
import ej.hoka.http.encoding.ChunkedTransferCodingHandler;
import ej.hoka.http.encoding.IHTTPEncodingHandler;
import ej.hoka.http.encoding.IHTTPTransferCodingHandler;
import ej.hoka.http.encoding.IdentityEncodingHandler;
import ej.hoka.http.encoding.IdentityTransferCodingHandler;
import ej.hoka.http.support.AcceptEncoding;
import ej.hoka.http.support.QualityArgument;

public class HTTPEncodingRegistry {
    private final PackedMap<String, IHTTPEncodingHandler> encodingHandlers = new PackedMap();
    private final PackedMap<String, IHTTPTransferCodingHandler> transferCodingHandlers = new PackedMap();

    public HTTPEncodingRegistry() {
        ChunkedTransferCodingHandler chunkedTransferCodingHandler = ChunkedTransferCodingHandler.getInstance();
        this.transferCodingHandlers.put((Object)chunkedTransferCodingHandler.getId(), (Object)chunkedTransferCodingHandler);
    }

    public IHTTPTransferCodingHandler getIdentityTransferCodingHandler() {
        return IdentityTransferCodingHandler.getInstance();
    }

    public IHTTPTransferCodingHandler getChunkedTransferCodingHandler() {
        return ChunkedTransferCodingHandler.getInstance();
    }

    public IHTTPEncodingHandler getEncodingHandler(String encoding) {
        if (encoding == null) {
            return IdentityEncodingHandler.getInstance();
        }
        PackedMap<String, IHTTPEncodingHandler> encodingHandlersMap = this.encodingHandlers;
        for (String key : encodingHandlersMap.keySet()) {
            IHTTPEncodingHandler handler = (IHTTPEncodingHandler)encodingHandlersMap.get((Object)key);
            if (!encoding.equalsIgnoreCase(handler.getId())) continue;
            return handler;
        }
        return null;
    }

    public IHTTPTransferCodingHandler getTransferCodingHandler(String encoding) {
        if (encoding == null) {
            return IdentityTransferCodingHandler.getInstance();
        }
        PackedMap<String, IHTTPTransferCodingHandler> transferCodingHandlersMap = this.transferCodingHandlers;
        for (String key : transferCodingHandlersMap.keySet()) {
            IHTTPTransferCodingHandler handler = (IHTTPTransferCodingHandler)transferCodingHandlersMap.get((Object)key);
            if (!encoding.equalsIgnoreCase(handler.getId())) continue;
            return handler;
        }
        return null;
    }

    public void registerEncodingHandler(IHTTPEncodingHandler handler) {
        this.encodingHandlers.put((Object)handler.getId(), (Object)handler);
    }

    public void registerTransferCodingHandler(IHTTPTransferCodingHandler handler) {
        this.transferCodingHandlers.put((Object)handler.getId(), (Object)handler);
    }

    public IHTTPEncodingHandler getAcceptEncodingHandler(String encoding) {
        if (encoding == null) {
            return null;
        }
        AcceptEncoding acceptEncoding = new AcceptEncoding();
        acceptEncoding.parse(encoding);
        QualityArgument[] encodings = acceptEncoding.getEncodings();
        int nbEncodings = encodings.length;
        boolean[] processed = new boolean[nbEncodings];
        int pass = nbEncodings - 1;
        while (pass >= 0) {
            float localMax = 0.0f;
            int ptrMax = -1;
            int i = nbEncodings - 1;
            while (i >= 0) {
                QualityArgument arg;
                float qvalue;
                if (!processed[i] && (qvalue = (arg = encodings[i]).getQuality()) > localMax) {
                    localMax = qvalue;
                    ptrMax = i;
                }
                --i;
            }
            processed[ptrMax] = true;
            IHTTPEncodingHandler handler = this.getEncodingHandler(encodings[ptrMax].getArgument());
            if (handler != null) {
                return handler;
            }
            --pass;
        }
        return null;
    }
}

