/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util;

import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothUuid;

public class BluetoothServicesUtil {
    public static final BluetoothUuid CUD_UUID = new BluetoothUuid(10497);
    public static final BluetoothUuid CCC_UUID = new BluetoothUuid(10498);
    private static final byte NOTIFICATIONS_ENABLED = 1;
    private static final byte INDICATIONS_ENABLED = 2;

    private BluetoothServicesUtil() {
    }

    public static BluetoothDescriptor createCUD() {
        return new BluetoothDescriptor(CUD_UUID, 1);
    }

    public static BluetoothDescriptor createCCC() {
        return new BluetoothDescriptor(CCC_UUID, 9);
    }

    public static boolean checkCccNotifications(byte[] value) {
        if (value.length != 2) {
            throw new IllegalArgumentException();
        }
        return (value[0] & 1) != 0;
    }

    public static boolean checkCccNIndication(byte[] value) {
        if (value.length != 2) {
            throw new IllegalArgumentException();
        }
        return (value[0] & 2) != 0;
    }

    public static byte[] makeCccValue(boolean notifications, boolean indications) {
        byte flags = 0;
        if (notifications) {
            flags = (byte)(flags | 1);
        } else if (indications) {
            flags = (byte)(flags | 2);
        }
        byte[] byArray = new byte[2];
        byArray[0] = flags;
        return byArray;
    }
}

