/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import ej.microui.display.LLUIDisplayImpl;
import ej.microui.display.LLUIPainter;
import java.util.concurrent.atomic.AtomicInteger;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label", isOptional=true), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="width"), @Widget.WidgetAttribute(name="height"), @Widget.WidgetAttribute(name="displayWidth", isOptional=true), @Widget.WidgetAttribute(name="displayHeight", isOptional=true), @Widget.WidgetAttribute(name="initialColor", isOptional=true), @Widget.WidgetAttribute(name="alpha", isOptional=true), @Widget.WidgetAttribute(name="doubleBufferFeature", isOptional=true), @Widget.WidgetAttribute(name="flushTime", isOptional=true), @Widget.WidgetAttribute(name="refreshRate", isOptional=true), @Widget.WidgetAttribute(name="backlightFeature", isOptional=true), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="extensionClass", isOptional=true)})
public class Display
extends Widget
implements LLUIDisplayImpl {
    private static final String PROPERTY_FLUSH_TIME = "ej.fp.widget.display.flushTime";
    private static final String PROPERTY_REFRESH_RATE = "ej.fp.widget.display.refreshRate";
    protected Image drawingBuffer;
    protected Image frameBuffer;
    protected Image visibleBuffer;
    private DisplayExtension extension;
    private String extensionClassName;
    private final FlushThread flushThread;
    private int displayWidth;
    private int displayHeight;
    private int initialColor;
    private byte alpha = (byte)-1;
    private boolean isDoubleBuffered = true;
    private boolean hasBacklight = true;
    private int flushTimeMs;
    private int refreshRateHz;
    private double refreshRateTimeMs;
    private int backlight;

    public Display() {
        this.flushThread = new FlushThread(this);
        this.flushThread.setPriority(1);
    }

    public void setDisplayWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Display width cannot be negative.");
        }
        this.displayWidth = width;
    }

    public void setDisplayHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Display height cannot be negative.");
        }
        this.displayHeight = height;
    }

    public void setInitialColor(int initialColor) {
        this.initialColor = initialColor | 0xFF000000;
    }

    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("The opacity level must be a value between 0x0 and 0xff");
        }
        this.alpha = (byte)alpha;
    }

    public void setDoubleBufferFeature(boolean enable) {
        this.isDoubleBuffered = enable;
    }

    public void setFlushTime(int ms) {
        this.flushTimeMs = ms > 0 ? ms : 0;
    }

    public void setRefreshRate(int hertz) {
        if (hertz > 0) {
            this.refreshRateHz = hertz > 0 ? hertz : 0;
            this.refreshRateTimeMs = 1000.0 / (double)hertz;
        } else {
            this.refreshRateHz = 0;
            this.refreshRateTimeMs = 0.0;
        }
    }

    public void setBacklightFeature(boolean enable) {
        this.hasBacklight = enable;
    }

    public void setExtensionClass(String extensionClassName) {
        this.extensionClassName = extensionClassName;
    }

    public synchronized void finalizeConfiguration() {
        super.finalizeConfiguration();
        if (this.displayWidth == 0) {
            this.displayWidth = this.getWidth();
        }
        if (this.displayHeight == 0) {
            this.displayHeight = this.getHeight();
        }
        if (this.extensionClassName != null) {
            FrontPanel.getFrontPanel().verifyUserClass(((Object)((Object)this)).getClass(), DisplayExtension.class, this.extensionClassName);
        }
        this.setOverlay(true);
        if (this.isDoubleBuffered()) {
            this.setFlushTime(this.getValue(PROPERTY_FLUSH_TIME, this.flushTimeMs));
            this.setRefreshRate(this.getValue(PROPERTY_REFRESH_RATE, this.refreshRateHz));
        }
        if (this.getFilter() == null && this.alpha != -1) {
            int color = this.alpha;
            Image filter = FrontPanel.getFrontPanel().newImage(this.getWidth(), this.getHeight(), color <<= 24, true);
            filter.fillRectangle(0, 0, this.getWidth(), this.getHeight(), color);
            this.setFilter(filter);
        }
    }

    public void showYourself(boolean appearSwitchedOn) {
        Image back = this.drawingBuffer;
        back.fillRectangle(0, 0, back.getWidth(), back.getHeight(), this.convertDisplayColorToARGBColor(this.convertARGBColorToDisplayColor(appearSwitchedOn ? ~this.getInitialColor() : this.getInitialColor())));
        this.flush(back, 0, 0, back.getWidth(), back.getHeight());
    }

    public void start() {
        super.start();
        if (this.extensionClassName != null) {
            this.extension = (DisplayExtension)FrontPanel.getFrontPanel().newUserInstance(((Object)((Object)this)).getClass(), DisplayExtension.class, this.extensionClassName);
        }
        this.visibleBuffer = this.newWidgetImage();
        this.frameBuffer = this.newDisplayImage();
        this.drawingBuffer = this.isDoubleBuffered() ? this.newDisplayImage() : this.frameBuffer;
        this.setBacklight(100);
        if (this.isDoubleBuffered()) {
            this.flushThread.start();
        }
    }

    public void dispose() {
        this.flushThread.dispose();
        FrontPanel.getFrontPanel().disposeIfNotNull(new Image[]{this.frameBuffer, this.visibleBuffer});
        if (this.drawingBuffer != this.frameBuffer) {
            FrontPanel.getFrontPanel().disposeIfNotNull(new Image[]{this.drawingBuffer});
        }
        this.frameBuffer = null;
        this.visibleBuffer = null;
        this.drawingBuffer = null;
        super.dispose();
    }

    public synchronized Image getCurrentSkin() {
        Image resultImage = this.visibleBuffer;
        resultImage.drawImage(this.frameBuffer);
        this.drawContrast(resultImage);
        this.drawBacklight(resultImage);
        resultImage.crop(this.getFilter());
        return resultImage;
    }

    public Image getDrawingBuffer() {
        return this.drawingBuffer;
    }

    public int getInitialColor() {
        return this.initialColor;
    }

    public Image initialize() {
        return this.getDrawingBuffer();
    }

    public boolean hasBacklight() {
        return this.hasBacklight;
    }

    public int getBacklight() {
        return this.hasBacklight() ? this.backlight : 0;
    }

    public void setBacklight(int backlight) {
        if (this.hasBacklight()) {
            this.backlight = this.backlight < 0 ? 0 : (this.backlight > 100 ? 100 : backlight);
            this.repaint();
        }
    }

    public boolean isDoubleBuffered() {
        return this.isDoubleBuffered;
    }

    public boolean isColor() {
        return this.extension != null ? this.extension.isColor(this) : super.isColor();
    }

    public int getNumberOfColors() {
        return this.extension != null ? this.extension.getNumberOfColors(this) : super.getNumberOfColors();
    }

    public int convertARGBColorToDisplayColor(int argbColor) {
        return this.extension != null ? this.extension.convertARGBColorToDisplayColor(this, argbColor) : super.convertARGBColorToDisplayColor(argbColor);
    }

    public int convertDisplayColorToARGBColor(int displayColor) {
        return this.extension != null ? this.extension.convertDisplayColorToARGBColor(this, displayColor) : super.convertDisplayColorToARGBColor(displayColor);
    }

    public boolean prepareBlendingOfIndexedColors(AtomicInteger foreground, AtomicInteger background) {
        return this.extension != null ? this.extension.prepareBlendingOfIndexedColors(this, foreground, background) : super.prepareBlendingOfIndexedColors(foreground, background);
    }

    public void flush(LLUIPainter.MicroUIGraphicsContext gc, Image image, int x, int y, int width, int height) {
        if (this.isDoubleBuffered()) {
            this.flushThread.wakeup(image, x, y, width, height);
        } else {
            this.flush(image, x, y, width, height);
        }
    }

    private void flush(Image image, int x, int y, int width, int height) {
        if (this.isDoubleBuffered()) {
            this.frameBuffer.drawImage(image, x, y, width, height, x, y, width, height);
        }
        if (this.alpha != -1) {
            this.getParent().repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        } else {
            this.repaint();
        }
    }

    public void waitFlush(LLUIPainter.MicroUIGraphicsContext gc) {
        if (this.isDoubleBuffered()) {
            this.flushThread.waitFlush();
        }
    }

    protected Image newDisplayImage() {
        return FrontPanel.getFrontPanel().newImage(this.displayWidth, this.displayHeight, this.initialColor, false);
    }

    protected Image newWidgetImage() {
        return FrontPanel.getFrontPanel().newImage(this.getWidth(), this.getHeight(), this.initialColor, true);
    }

    protected void drawContrast(Image imageSkin) {
    }

    protected void drawBacklight(Image imageSkin) {
        if (this.hasBacklight()) {
            int shadow = (100 - this.getBacklight()) * 255 / 100;
            imageSkin.fillTransparentRectangle(0, 0, imageSkin.getWidth(), imageSkin.getHeight(), shadow << 24);
        }
    }

    private int getValue(String property, int defaultValue) {
        String value = System.getProperty(property);
        if (value != null) {
            try {
                return Integer.parseInt(value, 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The value set in the property " + property + " is invalid: " + value);
            }
        }
        return defaultValue;
    }

    public static interface DisplayExtension {
        public boolean isColor(Display var1);

        public int getNumberOfColors(Display var1);

        public int convertARGBColorToDisplayColor(Display var1, int var2);

        public int convertDisplayColorToARGBColor(Display var1, int var2);

        default public boolean prepareBlendingOfIndexedColors(Display display, AtomicInteger foreground, AtomicInteger background) {
            return false;
        }
    }

    private static class FlushThread
    extends Thread {
        private final Display display;
        private Image image;
        private int x;
        private int y;
        private int width;
        private int height;
        private long lastFlushTime;
        private boolean isRunning;

        private FlushThread(Display display) {
            this.display = display;
            this.lastFlushTime = 0L;
            this.isRunning = true;
        }

        private synchronized void wakeup(Image image, int x, int y, int width, int height) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.notifyAll();
        }

        private synchronized void waitFlush() {
            while (this.isRunning && this.image != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void dispose() {
            this.isRunning = false;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isRunning) {
                FlushThread flushThread = this;
                synchronized (flushThread) {
                    while (this.isRunning && this.image == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                if (!this.isRunning) continue;
                this.flush();
                flushThread = this;
                synchronized (flushThread) {
                    this.image = null;
                    this.notifyAll();
                }
            }
        }

        private void flush() {
            long t0 = System.currentTimeMillis();
            double refreshRateTime = this.display.refreshRateTimeMs;
            if (refreshRateTime > 0.0) {
                double sleep = refreshRateTime - (double)(t0 - this.lastFlushTime) % refreshRateTime;
                this.simulateWork(t0, sleep);
            }
            this.lastFlushTime = System.currentTimeMillis();
            this.display.flush(this.image, this.x, this.y, this.width, this.height);
            this.simulateWork(this.lastFlushTime, this.display.flushTimeMs);
        }

        private void simulateWork(long t0, double ms) {
            while ((double)(System.currentTimeMillis() - t0) < ms) {
                Thread.yield();
            }
        }
    }
}

