/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.util.swipe;

import ej.annotation.Nullable;
import ej.bon.Util;
import ej.bon.XMath;
import ej.microui.event.Event;
import ej.microui.event.EventHandler;
import ej.microui.event.generator.Buttons;
import ej.microui.event.generator.Pointer;
import ej.motion.Function;
import ej.motion.Motion;
import ej.motion.quart.QuartEaseOutFunction;
import ej.mwt.animation.Animator;
import ej.widget.util.motion.MotionAnimation;
import ej.widget.util.motion.MotionAnimationListener;
import ej.widget.util.swipe.SwipeListener;
import ej.widget.util.swipe.Swipeable;

public class SwipeEventHandler
implements EventHandler {
    private static final int RELEASE_WITH_NO_MOVE_DELAY = 200;
    private static final float HALF = 0.5f;
    public static final int DEFAULT_DURATION = 800;
    private final int size;
    private final boolean cyclic;
    private final boolean horizontal;
    private final Swipeable swipeable;
    private final int itemInterval;
    @Nullable
    private final int[] itemsSize;
    private final Animator animator;
    @Nullable
    private MotionAnimation animation;
    @Nullable
    private SwipeListener swipeListener;
    private long duration;
    private Function motionFunction;
    private boolean pressed;
    private int initialValue;
    private int pressX;
    private int pressY;
    private int pressCoordinate;
    private long pressTime;
    private int previousCoordinate;
    private long lastTime;
    private int totalShift;
    private boolean forward;
    private int currentValue;
    private boolean dragged;
    private boolean swipeStarted;

    public SwipeEventHandler(int size, boolean cyclic, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(size, cyclic, 0, null, horizontal, swipeable, animator);
    }

    public SwipeEventHandler(int itemCount, int itemInterval, boolean cyclic, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(itemCount, itemInterval, cyclic, false, horizontal, swipeable, animator);
    }

    public SwipeEventHandler(int itemCount, int itemInterval, boolean cyclic, boolean snapToItem, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(SwipeEventHandler.computeSize(itemCount, itemInterval, cyclic), cyclic, snapToItem ? itemInterval : 0, null, horizontal, swipeable, animator);
        if (itemInterval <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public SwipeEventHandler(int[] itemsSize, boolean cyclic, boolean snapToItem, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(SwipeEventHandler.computeSize(itemsSize, cyclic), cyclic, snapToItem ? 1 : 0, itemsSize, horizontal, swipeable, animator);
    }

    private SwipeEventHandler(int size, boolean cyclic, int itemInterval, @Nullable int[] itemsSize, boolean horizontal, Swipeable swipeable, Animator animator) {
        assert (swipeable != null);
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.cyclic = cyclic;
        this.itemInterval = itemInterval;
        this.itemsSize = (int[])(itemsSize != null ? (int[])itemsSize.clone() : null);
        this.horizontal = horizontal;
        this.swipeable = swipeable;
        this.animator = animator;
        this.duration = 800L;
        this.motionFunction = QuartEaseOutFunction.INSTANCE;
    }

    private static int computeSize(int itemCount, int itemInterval, boolean cyclic) {
        return (itemCount - (cyclic ? 0 : 1)) * itemInterval;
    }

    private static int computeSize(int[] itemsSize, boolean cyclic) {
        int totalSize = 0;
        int[] nArray = itemsSize;
        int n = itemsSize.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            if (size <= 0) {
                throw new IllegalArgumentException();
            }
            totalSize += size;
            ++n2;
        }
        if (!cyclic) {
            totalSize -= itemsSize[itemsSize.length - 1];
        }
        return totalSize;
    }

    public int getCurrentPosition() {
        return this.currentValue;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setMotionFunction(Function motionFunction) {
        this.motionFunction = motionFunction;
    }

    public void setSwipeListener(@Nullable SwipeListener swipeListener) {
        this.swipeListener = swipeListener;
    }

    public void stop() {
        this.stopAnimation();
    }

    private int getCoordinate(int x, int y) {
        if (this.horizontal) {
            return x;
        }
        return y;
    }

    private void updateCurrentStep(int currentStep) {
        if (this.cyclic) {
            currentStep = this.modulo(currentStep, this.size);
        }
        this.currentValue = currentStep;
        this.swipeable.onMove(currentStep);
    }

    public boolean handleEvent(int event) {
        int type = Event.getType((int)event);
        if (type == 2) {
            Pointer pointer = (Pointer)Event.getGenerator((int)event);
            int pointerX = pointer.getX();
            int pointerY = pointer.getY();
            int pointerCoordinate = this.getCoordinate(pointerX, pointerY);
            int action = Buttons.getAction((int)event);
            switch (action) {
                case 0: {
                    this.onPointerPressed(pointerX, pointerY);
                    break;
                }
                case 7: {
                    return this.onPointerDragged(pointerX, pointerY);
                }
                case 1: {
                    return this.onPointerReleased(pointerCoordinate);
                }
            }
        }
        return false;
    }

    private void onPointerPressed(int pointerX, int pointerY) {
        int pressCoordinate;
        this.stopAnimation();
        this.pressed = true;
        this.pressTime = Util.platformTimeMillis();
        this.pressX = pointerX;
        this.pressY = pointerY;
        this.pressCoordinate = pressCoordinate = this.getCoordinate(pointerX, pointerY);
        this.previousCoordinate = pressCoordinate;
        this.initialValue = this.currentValue;
        this.totalShift = 0;
        this.dragged = false;
    }

    private boolean onPointerDragged(int pointerX, int pointerY) {
        boolean dragged;
        long currentTime;
        int pointerCoordinate = this.getCoordinate(pointerX, pointerY);
        if (!this.pressed) {
            this.onPointerPressed(pointerX, pointerY);
            return false;
        }
        this.lastTime = currentTime = Util.platformTimeMillis();
        int shift = pointerCoordinate - this.previousCoordinate;
        if (!this.dragged) {
            int shiftX = Math.abs(pointerX - this.pressX);
            int shiftY = Math.abs(pointerY - this.pressY);
            dragged = this.horizontal ? shiftX > shiftY : shiftY > shiftX;
        } else {
            dragged = shift != 0;
        }
        this.dragged |= dragged;
        if (dragged) {
            boolean currentForward;
            this.notifyStartSwipe();
            this.totalShift += shift;
            this.updateCurrentStep(this.initialValue - this.totalShift);
            this.previousCoordinate = pointerCoordinate;
            boolean bl = currentForward = shift > 0;
            if (this.totalShift != 0 && currentForward != this.forward) {
                this.pressCoordinate = pointerCoordinate;
                this.pressTime = currentTime;
                this.forward = currentForward;
            }
        }
        return dragged;
    }

    private boolean onPointerReleased(int pointerCoordinate) {
        long delay;
        int stop;
        int currentValue = this.currentValue;
        long duration = this.duration;
        if (this.dragged) {
            long currentTime = Util.platformTimeMillis();
            int limitedStep = this.limit(currentValue);
            if (!this.cyclic && limitedStep != currentValue) {
                stop = limitedStep;
                delay = duration / 2L;
            } else if (currentTime - this.lastTime < 200L) {
                float speed = -((float)(pointerCoordinate - this.pressCoordinate)) / (float)(2L * (currentTime - this.pressTime));
                stop = (int)((float)currentValue + speed * (float)duration);
                delay = duration;
            } else {
                stop = currentValue;
                delay = duration / 2L;
            }
        } else {
            stop = currentValue;
            delay = duration / 2L;
        }
        if (!this.cyclic) {
            stop = this.limit(stop);
        }
        this.moveTo(stop, delay);
        return this.dragged;
    }

    public int limit(int position) {
        return XMath.limit((int)position, (int)0, (int)this.size);
    }

    public void moveTo(int position) {
        this.stopAnimation();
        this.updateCurrentStep(this.snap(position));
    }

    private int snap(int position) {
        int itemInterval = this.itemInterval;
        int[] itemsSize = this.itemsSize;
        if (itemsSize != null && itemInterval != 0) {
            int currentSize = position / this.size * this.size;
            int[] nArray = itemsSize;
            int n = itemsSize.length;
            int n2 = 0;
            while (n2 < n) {
                int itemSize = nArray[n2];
                int nextSize = itemSize + currentSize;
                if (position < nextSize) {
                    if (position - currentSize < nextSize - position) {
                        return currentSize;
                    }
                    return nextSize;
                }
                currentSize = nextSize;
                ++n2;
            }
        } else if (itemInterval != 0) {
            return (int)((float)position / (float)itemInterval + 0.5f) * itemInterval;
        }
        return position;
    }

    public void moveTo(int stop, long duration) {
        this.stopAnimation();
        stop = this.snap(stop);
        if (stop == this.currentValue) {
            this.notifyStopSwipe();
            return;
        }
        Motion moveMotion = new Motion(this.motionFunction, this.currentValue, stop, duration);
        MotionAnimationListener motionListener = new MotionAnimationListener(){

            @Override
            public void tick(int value, boolean finished) {
                SwipeEventHandler.this.updateCurrentStep(value);
                if (finished) {
                    SwipeEventHandler.this.notifyStopSwipe();
                }
            }
        };
        this.notifyStartSwipe();
        this.animation = new MotionAnimation(this.animator, moveMotion, motionListener);
        this.animation.start();
    }

    private void stopAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation = null;
        }
    }

    private int modulo(int index, int length) {
        if ((index %= length) < 0) {
            index += length;
        }
        return index;
    }

    private void notifyStartSwipe() {
        if (!this.swipeStarted) {
            this.swipeStarted = true;
            SwipeListener swipeListener = this.swipeListener;
            if (swipeListener != null) {
                swipeListener.onSwipeStarted();
            }
        }
    }

    private void notifyStopSwipe() {
        if (this.swipeStarted) {
            SwipeListener swipeListener = this.swipeListener;
            if (swipeListener != null) {
                swipeListener.onSwipeStopped();
            }
            this.swipeStarted = false;
        }
    }
}

