/*
 * Decompiled with CFR 0.152.
 */
package org.apache.regexp;

import ej.annotation.Nullable;
import java.io.Serializable;

public class REProgram
implements Serializable {
    static final int OPT_HASBACKREFS = 1;
    static final int OPT_HASBOL = 2;
    char[] instruction;
    int lenInstruction;
    @Nullable
    char[] prefix;
    int flags;
    int maxParens = -1;

    public REProgram(char[] instruction) {
        this(instruction, instruction.length);
    }

    public REProgram(int parens, char[] instruction) {
        this(instruction, instruction.length);
        this.maxParens = parens;
    }

    public REProgram(char[] instruction, int lenInstruction) {
        this.setInstructions(instruction, lenInstruction);
    }

    @Nullable
    public char[] getInstructions() {
        if (this.lenInstruction != 0) {
            char[] ret = new char[this.lenInstruction];
            System.arraycopy(this.instruction, 0, ret, 0, this.lenInstruction);
            return ret;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setInstructions(char[] instruction, int lenInstruction) {
        short next;
        this.instruction = instruction;
        this.lenInstruction = lenInstruction;
        this.flags = 0;
        this.prefix = null;
        if (instruction == null) return;
        if (lenInstruction == 0) return;
        if (lenInstruction >= 3 && instruction[0] == '|' && instruction[(next = (short)instruction[2]) + 0] == 'E' && lenInstruction >= 6) {
            char nextOp = instruction[3];
            if (nextOp == 'A') {
                char lenAtom = instruction[4];
                char[] prefix = new char[lenAtom];
                this.prefix = prefix;
                System.arraycopy(instruction, 6, prefix, 0, lenAtom);
            } else if (nextOp == '^') {
                this.flags |= 2;
            }
        }
        int i = 0;
        while (i < lenInstruction) {
            switch (instruction[i + 0]) {
                case '[': {
                    i += instruction[i + 1] * 2;
                    break;
                }
                case 'A': {
                    i += instruction[i + 1];
                    break;
                }
                case '#': {
                    this.flags |= 1;
                    return;
                }
            }
            i += 3;
        }
    }

    @Nullable
    public char[] getPrefix() {
        char[] prefix = this.prefix;
        if (prefix != null) {
            char[] ret = new char[prefix.length];
            System.arraycopy(prefix, 0, ret, 0, prefix.length);
            return ret;
        }
        return null;
    }
}

