/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.event;

import ej.microui.event.Event;
import ej.microui.event.EventHandler;
import ej.microui.event.generator.Buttons;
import ej.microui.event.generator.Pointer;
import ej.mwt.Widget;
import ej.mwt.event.PointerEventDispatcher;

public abstract class PointerEventHandler
implements EventHandler {
    private final Widget widget;

    protected PointerEventHandler(Widget widget) {
        this.widget = widget;
    }

    public final boolean handleEvent(int event) {
        if (Event.getType((int)event) == 2) {
            Pointer pointer = (Pointer)Event.getGenerator((int)event);
            Widget widget = this.widget;
            int pointerX = pointer.getX() - widget.getAbsoluteX();
            int pointerY = pointer.getY() - widget.getAbsoluteY();
            int action = Buttons.getAction((int)event);
            if (action == 0) {
                return this.onPressed(pointerX, pointerY);
            }
            if (action == 7) {
                return this.onDragged(pointerX, pointerY);
            }
            if (action == 1) {
                return this.onReleased(pointerX, pointerY);
            }
        } else if (PointerEventDispatcher.isExited((int)event)) {
            this.onExited();
        }
        return false;
    }

    protected boolean onPressed(int pointerX, int pointerY) {
        return false;
    }

    protected boolean onDragged(int pointerX, int pointerY) {
        return false;
    }

    protected boolean onReleased(int pointerX, int pointerY) {
        return false;
    }

    protected void onExited() {
    }
}

