/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.log;

import ej.hoka.http.Config;
import ej.hoka.log.Logger;

class SimpleLogger
implements Logger {
    private static final int TRACE = 69905;
    private static final int DEBUG = 4369;
    private static final int INFO = 273;
    private static final int WARN = 17;
    private static final int ERROR = 1;
    private final int level;

    public SimpleLogger() {
        block24: {
            block22: {
                String slevel = Config.getInstance().getLoggerLevel();
                if (slevel == null || slevel.isEmpty()) break block22;
                switch (slevel.trim().toLowerCase()) {
                    case "none": {
                        this.level = 0;
                        break;
                    }
                    case "trace": {
                        this.level = 69905;
                        break;
                    }
                    case "debug": {
                        this.level = 4369;
                        break;
                    }
                    case "info": {
                        this.level = 273;
                        break;
                    }
                    case "warn": {
                        this.level = 17;
                        break;
                    }
                    case "error": {
                        this.level = 1;
                        break;
                    }
                    default: {
                        this.level = 273;
                        break;
                    }
                }
                break block24;
            }
            this.level = 273;
        }
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            System.out.println("[TRACE]\t" + msg);
        }
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            System.out.println("[DEBUG]\t" + msg);
        }
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            System.out.println("[INFO]\t" + msg);
        }
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            System.out.println("[WARN]\t" + msg);
        }
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            System.out.println("[ERROR]\t" + msg);
        }
    }

    @Override
    public void error(String msg, Throwable e) {
        if (this.isErrorEnabled()) {
            System.out.println("[ERROR]\t" + msg);
            e.printStackTrace();
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.isErrorEnabled()) {
            System.out.println("[ERROR]\t" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return (0x11111 & this.level) == 69905;
    }

    @Override
    public boolean isDebugEnabled() {
        return (0x1111 & this.level) == 4369;
    }

    @Override
    public boolean isInfoEnabled() {
        return (0x111 & this.level) == 273;
    }

    @Override
    public boolean isWarnEnabled() {
        return (0x11 & this.level) == 17;
    }

    @Override
    public boolean isErrorEnabled() {
        return (1 & this.level) == 1;
    }
}

