/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import java.util.Date;

public class Cookie {
    private final String name;
    private final String value;
    private String domain;
    private String path;
    private int maxAge;
    private Date expires;
    private boolean secured;
    private boolean httpOnly;
    private SameSite sameSite;

    Cookie(String name, String value, String domain, String path, int maxAge, Date expires, boolean secured, boolean httpOnly, SameSite sameSite) {
        this(name, value, maxAge);
        this.domain = domain;
        this.path = path;
        this.maxAge = maxAge;
        this.expires = expires;
        this.secured = secured;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
    }

    Cookie(String name, String value, int maxAge) {
        this.name = name;
        this.value = value;
        this.maxAge = maxAge;
    }

    public String toString() {
        StringBuilder cookie = new StringBuilder();
        cookie.append(this.name).append("=").append(this.value);
        if (this.maxAge != 0) {
            cookie.append("; Max-Age=").append(this.maxAge);
        }
        if (this.expires != null) {
            cookie.append("; Expires=").append(this.expires.toString());
        }
        if (this.path != null && !this.path.isEmpty()) {
            cookie.append("; Path=").append(this.path);
        }
        if (this.domain != null && !this.domain.isEmpty()) {
            cookie.append("; Domain=").append(this.domain);
        }
        if (this.secured) {
            cookie.append("; Secure");
        }
        if (this.httpOnly) {
            cookie.append("; HttpOnly");
        }
        if (this.sameSite != null) {
            cookie.append("; SameSite=" + this.sameSite.name());
        }
        return cookie.toString();
    }

    public static enum SameSite {
        Strict,
        Lax,
        None;

    }
}

