/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.map.PackedMap;
import ej.hoka.http.HaltException;
import ej.hoka.http.HttpRequest;
import ej.hoka.http.HttpResponse;
import ej.hoka.http.MethodNotAllowedException;
import ej.hoka.http.Route;
import ej.hoka.http.RouteNotFoundException;
import ej.hoka.http.requesthandler.RequestHandler;
import ej.hoka.http.requesthandler.StaticFilesHandler;
import ej.hoka.log.HokaLogger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

class RouteHandler
implements RequestHandler {
    private static final String PATH_PARAM_PREFIX = ":";
    protected static final String ALL_PATH = "+/*all-routes";
    private Route[] routes = new Route[0];
    private Route[] globalFilters = new Route[0];
    private Route[] pathFilters = new Route[0];
    private final PackedMap<Class<? extends Exception>, RequestHandler> exceptionHandlers = new PackedMap();
    private final boolean trailingSlashSupport;
    @Nullable
    private final String routeBase;
    @Nullable
    private final StaticFilesHandler staticFilesHandler;

    RouteHandler(String apiBase) {
        this(apiBase, null, false);
    }

    RouteHandler(String apiBase, @Nullable StaticFilesHandler staticFilesHandler) {
        this(apiBase, staticFilesHandler, false);
    }

    RouteHandler(String apiBase, @Nullable StaticFilesHandler staticFilesHandler, boolean trailingSlashSupport) {
        this.routeBase = apiBase;
        this.staticFilesHandler = staticFilesHandler;
        this.trailingSlashSupport = trailingSlashSupport;
    }

    private void processRoutesWithFilter(Route[] routes, int HttpMethod, HttpRequest request, HttpResponse response) {
        Route[] routeArray = routes;
        int n = routes.length;
        int n2 = 0;
        while (n2 < n) {
            Route r = routeArray[n2];
            if (HttpMethod == r.getHttpMethod()) {
                r.getHandler().process(request, response);
            }
            ++n2;
        }
    }

    private void processRoutesWithFilter(List<Route> routes, int HttpMethod, HttpRequest request, HttpResponse response) {
        for (Route r : routes) {
            if (HttpMethod != r.getHttpMethod()) continue;
            r.getHandler().process(request, response);
        }
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) {
        HashMap<String, String> headers;
        InputStream is;
        int requestHttpMethod = request.getMethod();
        String requestURI = request.getURI();
        String acceptType = request.getHeader("accept");
        StaticFilesHandler staticFilesHandler = this.staticFilesHandler;
        if (staticFilesHandler != null && (is = staticFilesHandler.serve(requestURI, headers = new HashMap<String, String>())) != null) {
            response.setData(is);
            response.addHeaders(headers);
            return;
        }
        List<Route> allowedRoutes = this.matchRoute(requestHttpMethod, acceptType, requestURI);
        Route route = null;
        for (Route r : allowedRoutes) {
            if (requestHttpMethod != r.getHttpMethod()) continue;
            route = r;
            break;
        }
        if (route != null) {
            this.setPathAndSplatParams(route.getPath(), request);
        }
        try {
            this.processRoutesWithFilter(this.globalFilters, 10, request, response);
            List<Route> beforeAfterpathFilters = this.matchPathFilters(requestHttpMethod, acceptType, requestURI);
            this.processRoutesWithFilter(beforeAfterpathFilters, 11, request, response);
            if (route == null) {
                if (!allowedRoutes.isEmpty()) {
                    throw new MethodNotAllowedException(allowedRoutes);
                }
                throw new RouteNotFoundException();
            }
            route.getHandler().process(request, response);
            this.processRoutesWithFilter(beforeAfterpathFilters, 12, request, response);
            this.processRoutesWithFilter(this.globalFilters, 13, request, response);
        }
        catch (HaltException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.exceptionHandlers.containsKey(e.getClass())) {
                RequestHandler key = (RequestHandler)this.exceptionHandlers.get(e.getClass());
                assert (key != null);
                key.process(request, response);
            }
            throw e;
        }
    }

    protected void setPathAndSplatParams(String routeURI, HttpRequest request) {
        if (!routeURI.contains(PATH_PARAM_PREFIX) && !routeURI.contains("*")) {
            return;
        }
        String[] routePathParts = this.pathToList(routeURI);
        String[] requestPathParts = this.pathToList(request.getURI());
        int nbrOfEndpointParts = routePathParts.length;
        int nbrOfRequestParts = requestPathParts.length;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<String> splatParams = new ArrayList<String>();
        int i = 0;
        while (i < nbrOfEndpointParts && i < nbrOfRequestParts) {
            if (this.isPathParam(routePathParts[i])) {
                pathParams.put(routePathParts[i].toLowerCase(), requestPathParts[i]);
            } else if (this.isSplatParam(routePathParts[i])) {
                StringBuilder splatParam = new StringBuilder(requestPathParts[i]);
                if (nbrOfEndpointParts != nbrOfRequestParts && i == nbrOfEndpointParts - 1) {
                    int j = i + 1;
                    while (j < nbrOfRequestParts) {
                        splatParam.append("/");
                        splatParam.append(requestPathParts[j]);
                        ++j;
                    }
                }
                splatParams.add(splatParam.toString());
            }
            ++i;
        }
        request.addPathParameters(pathParams);
        request.addSplatParameters(splatParams);
    }

    protected boolean isPathParam(String part) {
        return part.startsWith(PATH_PARAM_PREFIX);
    }

    protected boolean isSplatParam(String part) {
        return part.equals("*");
    }

    protected String[] pathToList(String path) {
        if ("/".equals(path)) {
            return new String[]{""};
        }
        StringTokenizer pathTokenizer = new StringTokenizer(path, "/");
        Object[] pathParts = new String[]{};
        while (pathTokenizer.hasMoreTokens()) {
            String pathPart = pathTokenizer.nextToken();
            pathParts = (String[])ArrayTools.add((Object[])pathParts, (Object)pathPart);
        }
        if (this.trailingSlashSupport && path.endsWith("/")) {
            pathParts = (String[])ArrayTools.add((Object[])pathParts, (Object)"");
        }
        return pathParts;
    }

    protected List<Route> matchRoute(int httpMethod, @Nullable String acceptType, String requestPath) {
        return this.matchRoute(this.routes, httpMethod, acceptType, requestPath);
    }

    protected List<Route> matchPathFilters(int httpMethod, @Nullable String acceptType, String requestPath) {
        return this.matchRoute(this.pathFilters, httpMethod, acceptType, requestPath);
    }

    private List<Route> matchRoute(Route[] routes, int httpMethod, @Nullable String acceptType, String requestPath) {
        if (!this.trailingSlashSupport && !"/".equals(requestPath) && requestPath.endsWith("/")) {
            requestPath = requestPath.substring(0, requestPath.length() - 1);
        }
        String[] requestAcceptedTypes = null;
        String[] requestPathParts = this.pathToList(requestPath);
        ArrayList<Route> matches = new ArrayList<Route>();
        Route[] routeArray = routes;
        int n = routes.length;
        int n2 = 0;
        while (n2 < n) {
            Route route = routeArray[n2];
            if (requestAcceptedTypes == null && !route.acceptAllContentTypes()) {
                requestAcceptedTypes = this.getRequestAcceptedTypes(acceptType);
            }
            if (route.getPath().equals(requestPath) && this.matchContentType(requestAcceptedTypes, route)) {
                matches.add(route);
                if (httpMethod == route.getHttpMethod()) {
                    return matches;
                }
            }
            if ((route.getPath().contains("*") || route.getPath().contains(PATH_PARAM_PREFIX)) && this.matchPath(route.getPath(), this.pathToList(route.getPath()), requestPathParts) && this.matchContentType(requestAcceptedTypes, route)) {
                matches.add(route);
                if (httpMethod == route.getHttpMethod()) {
                    return matches;
                }
            }
            ++n2;
        }
        return matches;
    }

    protected boolean matchContentType(@Nullable String[] requestAcceptedTypes, Route route) {
        return route.acceptAllContentTypes() || this.requestAcceptType(requestAcceptedTypes, route.getAcceptType());
    }

    protected boolean requestAcceptType(@Nullable String[] requestAcceptedTypes, @Nullable String routeAcceptType) {
        return requestAcceptedTypes == null || requestAcceptedTypes.length == 0 || ArrayTools.containsEquals((Object[])requestAcceptedTypes, (Object)"*/*") || routeAcceptType == null || ArrayTools.containsEquals((Object[])requestAcceptedTypes, (Object)routeAcceptType);
    }

    protected String[] getRequestAcceptedTypes(@Nullable String acceptType) {
        if (acceptType == null || acceptType.isEmpty()) {
            return new String[]{"*/*"};
        }
        StringTokenizer acceptTypeParser = new StringTokenizer(acceptType, ",");
        Object[] acceptedTypes = new String[]{};
        while (acceptTypeParser.hasMoreTokens()) {
            String type = acceptTypeParser.nextToken().trim();
            if (type.contains(";")) {
                type = type.substring(0, type.indexOf(59));
            }
            acceptedTypes = (String[])ArrayTools.add((Object[])acceptedTypes, (Object)type);
        }
        return acceptedTypes;
    }

    protected boolean matchPath(String routeURI, String[] routePathParts, String[] requestPathParts) {
        if (requestPathParts.length < routePathParts.length) {
            return false;
        }
        if (routePathParts.length != requestPathParts.length && !routeURI.endsWith("*")) {
            return false;
        }
        int i = 0;
        while (i < routePathParts.length) {
            String routePathPart = routePathParts[i];
            if (i == routePathParts.length - 1 && routePathPart.equals("*") && routeURI.endsWith("*")) {
                return true;
            }
            String requestPathPart = requestPathParts[i];
            if (!(routePathPart.startsWith(PATH_PARAM_PREFIX) || routePathPart.equalsIgnoreCase(requestPathPart) || routePathPart.equals("*"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void add(int httpMethod, String path, RequestHandler handler) {
        this.add(httpMethod, path, null, handler);
    }

    protected void add(int httpMethod, @Nullable String path, @Nullable String acceptType, @Nullable RequestHandler handler) {
        if (handler == null || path == null || path.isEmpty() || path.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        Route newRoute = new Route(httpMethod, this.appendBase(path), acceptType, handler);
        switch (httpMethod) {
            case 10: 
            case 13: {
                this.globalFilters = (Route[])ArrayTools.add((Object[])this.globalFilters, (Object)newRoute);
                break;
            }
            case 11: 
            case 12: {
                if (ArrayTools.containsEquals((Object[])this.pathFilters, (Object)newRoute)) {
                    throw new IllegalArgumentException(String.valueOf(newRoute.getHttpMethodAsString()) + " | " + newRoute.getPath() + " already exists.");
                }
                this.pathFilters = (Route[])ArrayTools.add((Object[])this.pathFilters, (Object)newRoute);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (ArrayTools.containsEquals((Object[])this.routes, (Object)newRoute)) {
                    throw new IllegalArgumentException(String.valueOf(newRoute.getHttpMethodAsString()) + " | " + newRoute.getPath() + " already exists.");
                }
                this.routes = (Route[])ArrayTools.add((Object[])this.routes, (Object)newRoute);
                break;
            }
            default: {
                throw new IllegalArgumentException("Http method not supported");
            }
        }
        this.logRegistredRoute(newRoute);
    }

    private void logRegistredRoute(Route r) {
        HokaLogger.instance.info(String.valueOf(r.getHttpMethodAsString()) + "   \t" + r.getPath() + "\t\t\t" + r.getHandler().getClass().getName());
    }

    protected void addExceptionHandler(@Nullable Class<? extends Exception> clazz, @Nullable RequestHandler handler) {
        if (clazz == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (this.exceptionHandlers.containsKey(clazz)) {
            RequestHandler value = (RequestHandler)this.exceptionHandlers.get(clazz);
            assert (value != null);
            throw new IllegalArgumentException("'" + clazz + "' is already mapped to '" + value.getClass().getName() + "'");
        }
        this.exceptionHandlers.put(clazz, (Object)handler);
    }

    protected List<Route> getRoutes() {
        return Collections.unmodifiableList(Arrays.asList(this.routes));
    }

    private String appendBase(String path) {
        if (this.routeBase == null || "".equals(this.routeBase) || path.startsWith("/")) {
            if (!path.startsWith("/")) {
                return "/" + path;
            }
            return path;
        }
        return String.valueOf(this.routeBase) + path;
    }
}

