/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline.border;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.drawing.ShapePainter;
import ej.microui.display.GraphicsContext;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

public class RoundedBorder
implements Outline {
    private static final float ARC_ANGLE = 90.0f;
    private static final float START_ANGLE_TOPLEFT = 90.0f;
    private static final float START_ANGLE_BOTTOMLEFT = 180.0f;
    private static final float START_ANGLE_TOPRRIGHT = 0.0f;
    private static final float START_ANGLE_BOTTOMRIGHT = 270.0f;
    private static final int FADE = 1;
    private static final ShapePainter.Cap CAP = ShapePainter.Cap.NONE;
    private final int color;
    private final char cornerRadius;
    private final char thickness;

    public RoundedBorder(int color, int cornerRadius, int thickness) {
        this.color = color;
        this.cornerRadius = (char)XMath.limit((int)cornerRadius, (int)0, (int)65535);
        this.thickness = (char)XMath.limit((int)thickness, (int)0, (int)65535);
    }

    public int getColor() {
        return this.color;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public int getThickness() {
        return this.thickness;
    }

    @Override
    public void apply(Outlineable outlineable) {
        char thickness = this.thickness;
        outlineable.removeOutline(thickness, thickness, thickness, thickness);
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        boolean hasBackgroundColor = g.hasBackgroundColor();
        int backgroundColor = g.getBackgroundColor();
        g.setColor(this.color);
        g.removeBackgroundColor();
        int width = size.getWidth();
        int height = size.getHeight();
        char thickness = this.thickness;
        int radius = Math.min(Math.max(this.cornerRadius, thickness + '\u0001'), Math.min(width, height) >> 1);
        int diameter = radius << 1;
        if (thickness > '\u0000') {
            int actualThickness = thickness - '\u0001';
            int actualDiameter = diameter - actualThickness - 1;
            int halfThickness = actualThickness >> 1;
            int oddThickness = thickness & '\u0001';
            int shift = halfThickness - oddThickness + 1;
            int oppositeShift = actualDiameter + shift;
            int xLeft = shift;
            int xRight = width - oppositeShift;
            int yTop = shift;
            int yBottom = height - oppositeShift;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int xLeftLine = radius - oddThickness;
            int xRightLine = width - xLeftLine - 1;
            if (xLeftLine == xRightLine) {
                g.intersectClip(xLeftLine, 0, 1, height);
                ++xRightLine;
            }
            if (xLeftLine < xRightLine) {
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)xLeftLine, (int)yTop, (int)xRightLine, (int)yTop, (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)xLeftLine, (int)(height - shift - 1), (int)xRightLine, (int)(height - shift - 1), (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
            int yTopLine = radius - oddThickness;
            int yBottomLine = height - yTopLine - 1;
            if (yTopLine == yBottomLine) {
                g.intersectClip(0, yTopLine, width, 1);
                ++yBottomLine;
            }
            if (yTopLine < yBottomLine) {
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)xLeft, (int)yTopLine, (int)xLeft, (int)yBottomLine, (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)(width - shift - 1), (int)yTopLine, (int)(width - shift - 1), (int)yBottomLine, (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
            ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)xLeft, (int)yTop, (int)actualDiameter, (float)90.0f, (float)90.0f, (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)xLeft, (int)yBottom, (int)actualDiameter, (float)180.0f, (float)90.0f, (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)xRight, (int)yTop, (int)actualDiameter, (float)0.0f, (float)90.0f, (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)xRight, (int)yBottom, (int)actualDiameter, (float)270.0f, (float)90.0f, (int)actualThickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
        }
        size.removeOutline(thickness, thickness, thickness, thickness);
        g.translate((int)thickness, (int)thickness);
        g.intersectClip(0, 0, size.getWidth(), size.getHeight());
        if (hasBackgroundColor) {
            g.setBackgroundColor(backgroundColor);
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RoundedBorder) {
            RoundedBorder border = (RoundedBorder)obj;
            return this.color == border.color && this.cornerRadius == border.cornerRadius && this.thickness == border.thickness;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.color + this.cornerRadius * this.thickness;
    }
}

