/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tool.classextender.helper;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.bytecode.ClassFile;

public class JarUpdater {
    private static final Logger LOGGER = Logger.getLogger(JarUpdater.class.getName());
    private final File jarFile;
    private final URI jarUri;

    public JarUpdater(File jarFile) {
        this.jarFile = jarFile;
        this.jarUri = URI.create("jar:" + jarFile.toPath().toUri());
    }

    public void update(File ... classFiles) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileSystem jarFs = FileSystems.newFileSystem(this.jarUri, new HashMap());){
                File[] fileArray = classFiles;
                int n = classFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File classFile = fileArray[n2];
                    Path newClassFilePath = classFile.toPath();
                    Path jarEntryPath = jarFs.getPath(this.getRelativePath(classFile), new String[0]);
                    Files.copy(newClassFilePath, jarEntryPath, StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.log(Level.INFO, "Update {0} in {1}", new Object[]{jarEntryPath, this.jarFile.getName()});
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "An error occured while updating jar {0}: {1}", new Object[]{this.jarFile.getName(), e.getMessage()});
        }
    }

    private String getRelativePath(File newFile) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataInputStream is = new DataInputStream(new FileInputStream(newFile));){
            ClassFile classFile = new ClassFile(is);
            return "/" + classFile.getName().replace('.', '/').concat(".class");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

