/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.http;

import ej.websocket.http.Header;
import ej.websocket.http.StatusLine;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class HttpResponse {
    private static final int ORIGINAL_LINE_BUFFER_SIZE = 128;
    private static final String CRLF = "\r\n";
    private final StatusLine statusLine;
    private final List<Header> allHeaders;

    public HttpResponse(InputStream is) throws IOException {
        String line = this.getNextLine(is);
        this.statusLine = new StatusLine(line);
        this.allHeaders = new ArrayList<Header>();
        while (!CRLF.equals(line = this.getNextLine(is))) {
            Header header = new Header(line);
            this.allHeaders.add(header);
        }
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public Header getHeader(String name) {
        Header header = null;
        for (Header current : this.allHeaders) {
            if (current.getName().compareToIgnoreCase(name) != 0) continue;
            header = current;
            break;
        }
        return header;
    }

    public List<Header> getAllHeaders() {
        return new ArrayList<Header>(this.allHeaders);
    }

    private String getNextLine(InputStream is) throws IOException {
        char[] buffer = new char[128];
        int i = 0;
        int previous = 0;
        int current = 0;
        do {
            previous = current;
            current = is.read();
            if (current == -1) {
                throw new IOException();
            }
            buffer[i] = (char)current;
            if (++i != buffer.length) continue;
            char[] temp = new char[buffer.length * 2];
            System.arraycopy(buffer, 0, temp, 0, i);
            buffer = temp;
        } while (previous != 13 || current != 10);
        return String.valueOf(buffer, 0, i);
    }

    public String toString() {
        return "HttpResponse [" + this.statusLine + "\n" + this.allHeaders + "]";
    }
}

