/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SequenceInputStream
extends InputStream {
    Enumeration<? extends InputStream> e;
    @Nullable
    InputStream in;

    public SequenceInputStream(Enumeration<? extends InputStream> e) {
        this.e = e;
        try {
            this.nextStream();
        }
        catch (IOException iOException) {
            throw new Error("panic");
        }
    }

    public SequenceInputStream(InputStream s1, InputStream s2) {
        Vector<InputStream> v = new Vector<InputStream>(2);
        v.addElement(s1);
        v.addElement(s2);
        this.e = v.elements();
        try {
            this.nextStream();
        }
        catch (IOException iOException) {
            throw new Error("panic");
        }
    }

    final void nextStream() throws IOException {
        InputStream in = this.in;
        if (in != null) {
            in.close();
        }
        if (this.e.hasMoreElements()) {
            in = this.e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        } else {
            this.in = null;
        }
    }

    @Override
    public int available() throws IOException {
        InputStream in = this.in;
        if (in == null) {
            return 0;
        }
        return in.available();
    }

    @Override
    public int read() throws IOException {
        InputStream in = this.in;
        if (in == null) {
            return -1;
        }
        int c = in.read();
        if (c == -1) {
            this.nextStream();
            return this.read();
        }
        return c;
    }

    @Override
    public int read(@Nullable byte[] b, int off, int len) throws IOException {
        InputStream in = this.in;
        if (in == null) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = in.read(b, off, len);
        if (n <= 0) {
            this.nextStream();
            return this.read(b, off, len);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        do {
            this.nextStream();
        } while (this.in != null);
    }
}

