/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    @Nullable
    private Reader in;
    @Nullable
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public BufferedReader(Reader in, int sz) {
        super((Object)in);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = in;
        this.cb = new char[sz];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public BufferedReader(Reader in) {
        this(in, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int dst;
        char[] cb = this.cb;
        assert (cb != null);
        Reader in = this.in;
        assert (in != null);
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= cb.length) {
                    System.arraycopy(cb, this.markedChar, cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    System.arraycopy(cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = in.read(cb, dst, cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            char[] cb = this.cb;
            assert (cb != null);
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
                if (!this.skipLF) break;
                this.skipLF = false;
                if (cb[this.nextChar] != '\n') break;
                ++this.nextChar;
            }
            return cb[this.nextChar++];
        }
    }

    private int read1(char[] cbuf, int off, int len) throws IOException {
        char[] cb = this.cb;
        assert (cb != null);
        Reader in = this.in;
        assert (in != null);
        if (this.nextChar >= this.nChars) {
            if (len >= cb.length && this.markedChar <= -1 && !this.skipLF) {
                return in.read(cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (cb[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(len, this.nChars - this.nextChar);
        System.arraycopy(cb, this.nextChar, cbuf, off, n);
        this.nextChar += n;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n1;
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int n = this.read1(cbuf, off, len);
            if (n <= 0) {
                return n;
            }
            Reader in = this.in;
            assert (in != null);
            while (n < len && in.ready() && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
                n += n1;
            }
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    String readLine(boolean ignoreLF) throws IOException {
        StringBuffer s = null;
        Object object = this.lock;
        synchronized (object) {
            boolean omitLF;
            this.ensureOpen();
            boolean bl = omitLF = ignoreLF || this.skipLF;
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (s != null && s.length() > 0) {
                        return s.toString();
                    }
                    return null;
                }
                boolean eol = false;
                char c = '\u0000';
                char[] cb = this.cb;
                assert (cb != null);
                if (!omitLF || cb[this.nextChar] == '\n') {
                    // empty if block
                }
                this.skipLF = false;
                omitLF = false;
                int i = ++this.nextChar;
                while (i < this.nChars) {
                    c = cb[i];
                    if (c == '\n' || c == '\r') {
                        eol = true;
                        break;
                    }
                    ++i;
                }
                int startChar = this.nextChar;
                this.nextChar = i;
                if (eol) {
                    String str;
                    if (s == null) {
                        str = new String(cb, startChar, i - startChar);
                    } else {
                        s.append(cb, startChar, i - startChar);
                        str = s.toString();
                    }
                    ++this.nextChar;
                    if (c == '\r') {
                        this.skipLF = true;
                    }
                    return str;
                }
                if (s == null) {
                    s = new StringBuffer(defaultExpectedLineLength);
                }
                s.append(cb, startChar, i - startChar);
            }
        }
    }

    @Nullable
    public String readLine() throws IOException {
        return this.readLine(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            long r = n;
            while (r > 0L) {
                long d;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                if (this.skipLF) {
                    this.skipLF = false;
                    char[] cb = this.cb;
                    assert (cb != null);
                    if (cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                }
                if (r <= (d = (long)(this.nChars - this.nextChar))) {
                    this.nextChar = (int)((long)this.nextChar + r);
                    r = 0L;
                    break;
                }
                r -= d;
                this.nextChar = this.nChars;
            }
            return n - r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            Reader in = this.in;
            assert (in != null);
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    char[] cb = this.cb;
                    assert (cb != null);
                    if (cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || in.ready();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = readAheadLimit;
            this.markedChar = this.nextChar;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.nextChar = this.markedChar;
            this.skipLF = this.markedSkipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Reader in = this.in;
            if (in == null) {
                return;
            }
            try {
                in.close();
            }
            finally {
                this.in = null;
                this.cb = null;
            }
        }
    }
}

