/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.debug;

import ej.microui.display.Font;
import ej.mwt.Container;
import ej.mwt.Desktop;
import ej.mwt.Widget;
import ej.mwt.style.DefaultStyle;
import ej.mwt.style.Style;
import ej.mwt.style.background.Background;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.outline.Outline;
import ej.mwt.stylesheet.cascading.CascadingStylesheet;
import ej.mwt.stylesheet.selector.Selector;
import ej.widget.debug.Stringifier;
import ej.widget.debug.WidgetVisitor;
import java.util.ArrayList;

public class HierarchyInspector {
    private static final Selector[] EMPTY_STYLE_SOURCE = new Selector[0];

    private HierarchyInspector() {
    }

    public static void visitHierarchy(Widget widget, WidgetVisitor visitor) {
        visitor.visitWidget(widget);
        if (widget instanceof Container) {
            visitor.beginContainer();
            Container container = (Container)widget;
            int childrenCount = container.getChildrenCount();
            int i = 0;
            while (i < childrenCount) {
                Widget child = container.getChild(i);
                HierarchyInspector.visitHierarchy(child, visitor);
                ++i;
            }
            visitor.endContainer();
        }
    }

    public static int countInstances(Widget root, final Class<? extends Widget> clazz) {
        final IntHolder count = new IntHolder(0);
        HierarchyInspector.visitHierarchy(root, new WidgetVisitor(){

            @Override
            public void beginContainer() {
            }

            @Override
            public void visitWidget(Widget widget) {
                if (clazz.isInstance(widget)) {
                    IntHolder intHolder = count;
                    intHolder.value = intHolder.value + 1;
                }
            }

            @Override
            public void endContainer() {
            }
        });
        return count.value;
    }

    public static int countNumberOfContainers(Widget root) {
        return HierarchyInspector.countInstances(root, Container.class);
    }

    public static int countNumberOfWidgets(Widget root) {
        return HierarchyInspector.countInstances(root, Widget.class);
    }

    public static int countMaxDepth(Widget root) {
        final IntHolder count = new IntHolder(0);
        HierarchyInspector.visitHierarchy(root, new WidgetVisitor(){
            int depth = 0;

            @Override
            public void beginContainer() {
                ++this.depth;
            }

            @Override
            public void visitWidget(Widget widget) {
                int depth = this.depth;
                if (depth > count.value) {
                    count.value = depth;
                }
            }

            @Override
            public void endContainer() {
                --this.depth;
            }
        });
        return count.value;
    }

    public static String hierarchyToString(Widget root) {
        return HierarchyInspector.hierarchyToString(root, false);
    }

    public static void printHierarchy(Widget root) {
        System.out.println(HierarchyInspector.hierarchyToString(root));
    }

    public static String hierarchyStyleToString(Widget root) {
        if (!root.isAttached()) {
            throw new IllegalArgumentException();
        }
        return HierarchyInspector.hierarchyToString(root, true);
    }

    public static void printHierarchyStyle(Widget root) {
        System.out.println(HierarchyInspector.hierarchyStyleToString(root));
    }

    private static String hierarchyToString(Widget root, final boolean appendStyle) {
        final StringBuilder builder = new StringBuilder();
        WidgetVisitor visitor = new WidgetVisitor(){
            int depth = 0;

            @Override
            public void beginContainer() {
                ++this.depth;
            }

            @Override
            public void visitWidget(Widget widget) {
                HierarchyInspector.appendDepth(builder, this.depth);
                HierarchyInspector.appendElement(builder, widget);
                HierarchyInspector.appendPosition(builder, widget);
                if (appendStyle) {
                    Style style = widget.getStyle();
                    HierarchyInspector.appendStyle(builder, style);
                }
                builder.append("\n");
            }

            @Override
            public void endContainer() {
                --this.depth;
            }
        };
        HierarchyInspector.visitHierarchy(root, visitor);
        return builder.toString();
    }

    private static void appendPosition(StringBuilder builder, Widget widget) {
        builder.append('{');
        builder.append("x=").append(widget.getAbsoluteX());
        builder.append(',');
        builder.append("y=").append(widget.getAbsoluteY());
        builder.append(',');
        builder.append("w=").append(widget.getWidth());
        builder.append(',');
        builder.append("h=").append(widget.getHeight());
        builder.append('}');
    }

    private static void appendHierarchyRecursive(StringBuilder builder, Widget widget, int depth) {
        HierarchyInspector.appendDepth(builder, depth);
        HierarchyInspector.appendElement(builder, widget);
        builder.append('\n');
        if (widget instanceof Container) {
            HierarchyInspector.appendChildrenHierarchy(builder, (Container)widget, depth);
        }
    }

    private static void appendChildrenHierarchy(StringBuilder builder, Container container, int depth) {
        int childrenCount = container.getChildrenCount();
        int i = 0;
        while (i < childrenCount) {
            Widget child = container.getChild(i);
            HierarchyInspector.appendHierarchyRecursive(builder, child, depth + 1);
            ++i;
        }
    }

    static StringBuilder appendDepth(StringBuilder builder, int depth) {
        while (depth > 1) {
            builder.append('|').append(' ').append(' ');
            --depth;
        }
        if (depth > 0) {
            builder.append('+').append('-').append('-');
        }
        return builder;
    }

    private static void appendStyle(StringBuilder builder, Style style) {
        Dimension dimension = style.getDimension();
        int color = style.getColor();
        Background background = style.getBackground();
        Outline border = style.getBorder();
        Outline padding = style.getPadding();
        Outline margin = style.getMargin();
        Font font = style.getFont();
        int horizontalAlignment = style.getHorizontalAlignment();
        int verticalAlignment = style.getVerticalAlignment();
        Selector[] styleSource = HierarchyInspector.getStyleSources(style);
        ArrayList<String> entries = new ArrayList<String>();
        if (!DefaultStyle.DIMENSION.equals((Object)dimension)) {
            entries.add("dimension=" + Stringifier.toString(dimension) + HierarchyInspector.from(styleSource, 0));
        }
        if (color != 0) {
            entries.add("color=" + Stringifier.colorToString(color) + HierarchyInspector.from(styleSource, 7));
        }
        if (!DefaultStyle.BACKGROUND.equals((Object)background)) {
            entries.add("background=" + Stringifier.toString(background) + HierarchyInspector.from(styleSource, 6));
        }
        if (!DefaultStyle.BORDER.equals((Object)border)) {
            entries.add("border=" + Stringifier.toString(border) + HierarchyInspector.from(styleSource, 4));
        }
        if (!DefaultStyle.PADDING.equals((Object)padding)) {
            entries.add("padding=" + Stringifier.toString(padding) + HierarchyInspector.from(styleSource, 5));
        }
        if (!DefaultStyle.MARGIN.equals((Object)margin)) {
            entries.add("margin=" + Stringifier.toString(margin) + HierarchyInspector.from(styleSource, 3));
        }
        if (!Font.getDefaultFont().equals(font)) {
            entries.add("font=" + Stringifier.toString(font) + HierarchyInspector.from(styleSource, 8));
        }
        if (horizontalAlignment != 0) {
            entries.add("horizontalAlignment=" + Stringifier.alignmentToString(horizontalAlignment) + HierarchyInspector.from(styleSource, 1));
        }
        if (3 != verticalAlignment) {
            entries.add("verticalAlignment=" + Stringifier.alignmentToString(verticalAlignment) + HierarchyInspector.from(styleSource, 2));
        }
        if (!entries.isEmpty()) {
            builder.append(" (");
            int n = entries.size() - 1;
            int i = 0;
            while (i < n) {
                builder.append((String)entries.get(i)).append(", ");
                ++i;
            }
            builder.append((String)entries.get(n)).append(")");
        }
    }

    private static Selector[] getStyleSources(Style style) {
        try {
            return CascadingStylesheet.getStyleSources((Style)style);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return EMPTY_STYLE_SOURCE;
        }
    }

    private static String from(Selector[] styleSource, int index) {
        if (styleSource != null && styleSource.length != 0) {
            return " from " + HierarchyInspector.getSelector(styleSource, index);
        }
        return "";
    }

    private static String getSelector(Selector[] styleSource, int index) {
        Selector selector = styleSource[index];
        if (selector == null) {
            return "default";
        }
        return Stringifier.toString(selector);
    }

    public static String pathToWidgetToString(Widget widget) {
        return HierarchyInspector.pathToWidgetToString(widget, '>');
    }

    public static String pathToWidgetToString(Widget widget, char separator) {
        StringBuilder builder = new StringBuilder();
        if (widget.isAttached()) {
            Desktop desktop = widget.getDesktop();
            HierarchyInspector.appendElement(builder, desktop);
            HierarchyInspector.appendSeparator(builder, separator);
        }
        HierarchyInspector.pathToWidgetRecursive(builder, widget, separator);
        return builder.toString();
    }

    private static void pathToWidgetRecursive(StringBuilder builder, Widget widget, char separator) {
        Container parent = widget.getParent();
        if (parent != null) {
            HierarchyInspector.pathToWidgetRecursive(builder, (Widget)parent, separator);
            HierarchyInspector.appendSeparator(builder, separator);
        }
        HierarchyInspector.appendElement(builder, widget);
    }

    static StringBuilder appendElement(StringBuilder builder, Object object) {
        Class<?> clazz = object.getClass();
        String name = clazz.getSimpleName();
        if (name.equals("@")) {
            name = clazz.getName();
        }
        name = HierarchyInspector.canonizeClassName(name);
        builder.append(name);
        return builder;
    }

    static String canonizeClassName(String className) {
        int length;
        if (className.startsWith("@T:")) {
            className = className.substring(3);
        }
        if ((length = className.length()) > 1 && className.charAt(length - 1) == '@') {
            className = className.substring(0, length - 1);
        }
        return className;
    }

    private static void appendSeparator(StringBuilder builder, char separator) {
        builder.append(' ').append(separator).append(' ');
    }

    private static class IntHolder {
        private int value;

        public IntHolder(int initialValue) {
            this.value = initialValue;
        }
    }
}

