/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.basic;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.ResourceImage;
import ej.mwt.Widget;
import ej.mwt.style.Style;
import ej.mwt.util.Size;
import ej.widget.render.ImagePainter;

public class ImageWidget
extends Widget {
    private String imagePath;
    @Nullable
    private ResourceImage.OutputFormat outputFormat;
    @Nullable
    private ResourceImage image;

    public ImageWidget(String imagePath) {
        ImageWidget.checkImage(imagePath);
        this.imagePath = imagePath;
    }

    public ImageWidget(String imagePath, ResourceImage.OutputFormat outputFormat) {
        this(imagePath, outputFormat, false);
    }

    protected ImageWidget(String imagePath, boolean enabled) {
        super(enabled);
        ImageWidget.checkImage(imagePath);
        this.imagePath = imagePath;
    }

    protected ImageWidget(String imagePath, ResourceImage.OutputFormat outputFormat, boolean enabled) {
        super(enabled);
        ImageWidget.checkImage(imagePath);
        this.imagePath = imagePath;
        this.outputFormat = outputFormat;
    }

    protected void onAttached() {
        super.onAttached();
        this.loadImage();
    }

    protected void onDetached() {
        super.onDetached();
        this.closeImage();
    }

    private void loadImage() {
        this.image = ResourceImage.loadImage((String)this.imagePath, (ResourceImage.OutputFormat)this.outputFormat);
    }

    private void closeImage() {
        ResourceImage image = this.image;
        if (image != null) {
            image.close();
            this.image = null;
        }
    }

    public void setImagePath(String imagePath) {
        ImageWidget.checkImage(imagePath);
        this.imagePath = imagePath;
        if (this.isAttached()) {
            this.closeImage();
            this.loadImage();
        }
    }

    protected void renderContent(GraphicsContext g, int contentWidth, int contentHeight) {
        ResourceImage image = this.image;
        if (image != null) {
            Style style = this.getStyle();
            g.setColor(style.getColor());
            ImagePainter.drawImageInArea(g, (Image)image, 0, 0, contentWidth, contentHeight, style.getHorizontalAlignment(), style.getVerticalAlignment());
        }
    }

    protected void computeContentOptimalSize(Size size) {
        ResourceImage image = this.image;
        if (image != null) {
            ImagePainter.computeOptimalSize((Image)image, size);
        } else {
            size.setSize(0, 0);
        }
    }

    private static void checkImage(String imagePath) {
        if (!ResourceImage.canLoadImage((String)imagePath)) {
            throw new IllegalArgumentException();
        }
    }
}

