/*
 * Java
 *
 * Copyright 2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.microvg.test;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import ej.microui.display.Colors;
import ej.microui.display.Display;
import ej.microui.display.GraphicsContext;
import ej.microvg.VectorFont;
import ej.microvg.VectorGraphicsPainter;

/**
 * Tests open type fonts.
 */
public class TestFontIncorrectOTFGlyphSize {

	private static final String STRING_SQUARE = "A";
	private static final char CHAR_SQUARE = 'A';
	private static final int PADDING = 1;

	/**
	 * Starts MicroUI.
	 */
	@BeforeClass
	public static void pre() {
		TestUtilities.startMicroUI();
	}

	/**
	 * Stops MicroUI.
	 */
	@AfterClass
	public static void post() {
		TestUtilities.stopMicroUI();
	}

	/**
	 * Resets the content of the screen to black.
	 */
	@Before
	public static void preTest() {
		TestUtilities.clearScreen();
	}

	/**
	 * Tests drawing a text with a font in TTF and OTF format. (see M0092MEJAUI-2435)
	 */
	@Test
	public static void testOpenTypeVersusTrueType() {

		// Known issue with OpenType font sizes.
		if (TestUtilities.isOnSimulator()) {
			return;
		}

		Display display = Display.getDisplay();
		GraphicsContext g = display.getGraphicsContext();
		VectorFont fontTTF = VectorFont.loadFont("/fonts/neuzeit.ttf");
		VectorFont fontOTF = VectorFont.loadFont("/fonts/neuzeit.otf");

		String string = STRING_SQUARE;
		int fontSize = 50;

		int x = display.getWidth() / 2;
		int y = display.getHeight() / 2;

		int color = Colors.WHITE;

		fontOTF.measureStringHeight(Character.toString(CHAR_SQUARE), 50);
		fontTTF.measureStringHeight(Character.toString(CHAR_SQUARE), 50);

		g.setColor(color);
		VectorGraphicsPainter.drawString(g, string, fontOTF, fontSize, x + 100, y);
		VectorGraphicsPainter.drawString(g, string, fontTTF, fontSize, x, y);
		display.flush();

		// test pixels inside the TTF character
		TestUtilities.checkArea("TTF", color, x, y, fontSize, fontSize, PADDING);
		// test pixels outside the TTF character
		TestUtilities.checkPeripheralArea("TTF", Colors.BLACK, x, y, fontSize, fontSize, 20, 3);

		// test pixels inside the OTF character
		TestUtilities.checkArea("OTF", color, x + 100, y, fontSize, fontSize, PADDING);
		// test pixels outside the OTF character
		TestUtilities.checkPeripheralArea("OTF", Colors.BLACK, x + 100, y, fontSize, fontSize, 20, 3);
	}
}
