/*
 * Copyright 2014-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.motion.linear;

import ej.motion.Function;

/**
 * Represents a uniform linear motion: the velocity is constant (no acceleration or deceleration).
 */
public class LinearFunction implements Function {

	/**
	 * Singleton to avoid creating several instances.
	 */
	public static final LinearFunction INSTANCE = new LinearFunction();

	private LinearFunction() {
	}

	@Override
	public float computeValue(float t) {
		return t;
	}

}
