/*
 * Java
 *
 * Copyright 2022-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg;

import ej.microui.MicroUIException;
import ej.microui.display.BufferedImage;
import ej.microui.display.Format;
import ej.microui.display.GraphicsContext;

/**
 * A buffered vector image is a vector image that can be built dynamically.
 * <p>
 * It reserves the format {@link Format#CUSTOM_7} from MicroUI.
 *
 * @see BufferedImage
 */
public class BufferedVectorImage extends ResourceVectorImage {

	/**
	 * Creates a buffered image that holds the GPU commands.
	 * <p>
	 * A command is added in the image when the image's {@link GraphicsContext} is used to draw something into.
	 *
	 * @param width
	 *            the width of the new image, in pixels
	 * @param height
	 *            the height of the new image, in pixels
	 *
	 * @see BufferedImage#getGraphicsContext()
	 */
	public BufferedVectorImage(int width, int height) {
		throw new VectorGraphicsException();
	}

	/**
	 * Returns the {@link GraphicsContext} associated with this image, which may be used in order to draw on the image.
	 * <p>
	 * This method always returns the same {@link GraphicsContext} instance for a specific image. The graphics context
	 * has the same dimensions as the image.
	 *
	 * @throws MicroUIException
	 *             if this image has been closed (see {@link #close()}).
	 * @return the image's graphics context.
	 */
	public GraphicsContext getGraphicsContext() {
		throw new VectorGraphicsException();
	}

	/**
	 * Clears all commands.
	 */
	public void clear() {
		throw new VectorGraphicsException();
	}
}
