/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image.pathdata;

import ej.microvg.image.ImageGenerator.Format;

/**
 * Encodes a path with 8-bit values: the commands and the commands' attributes are encoded with 8-bit signed values.
 */
public class SingleArrayPathDataS8 extends SingleArrayPathData {

	@Override
	public Format getFormat() {
		return Format.VG_S8;
	}

	@Override
	public void appendCommand(int command) {
		append((byte) command);
	}

	@Override
	public void appendCoordinate(double coordinate) {
		append((byte) coordinate);
	}

	private void append(byte i) {
		write(i);
	}

}
