/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image.pathdata;

import ej.microvg.image.ImageGenerator.Format;

/**
 * Encodes a path with 32-bit values: the commands are encoded with 32-bit signed values and the commands' attributes
 * are encoded with 32-bit floating values.
 */
public class SingleArrayPathDataFP32 extends SingleArrayPathData {

	@Override
	public Format getFormat() {
		return Format.VG_FP32;
	}

	@Override
	public void appendCommand(int command) {
		append(command);
	}

	@Override
	public void appendCoordinate(double coordinate) {
		int i = Float.floatToIntBits((float) coordinate);
		append(i);
	}

	private void append(int i) {
		write((byte) (i));
		write((byte) (i >> 8));
		write((byte) (i >> 16));
		write((byte) (i >> 24));
	}

}
