/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.control.net;

import java.util.Date;

/**
 * Exception thrown when a bandwidth limit (fs/net) is exceeded.
 */
public class BandwidthLimitException extends SecurityException {

	private static final long serialVersionUID = -6852081546561586687L;

	private final Date date;

	/**
	 * Constructs a new exception with {@code null} as its detail message. The cause is not initialized, and may
	 * subsequently be initialized by a call to {@link #initCause}.
	 *
	 * @param date
	 * 		the date from which the bandwidth is available.
	 */
	public BandwidthLimitException(Date date) {
		super();

		this.date = date;
	}

	public Date getNextDate() {
		return this.date;
	}
}
