/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.control.net;

/**
 * Bandwidth representation with a maximum bytes to read and write per period.
 */
public class Bandwidth {

	public enum Period {
		SECOND, HOUR, DAY
	}

	private final BandwidthChecker readBandwidthChecker;
	private final BandwidthChecker writeBandwidthChecker;

	/**
	 * Creates a Bandwidth instance.
	 *
	 * @param period
	 * 		the period over which the limit is applied.
	 * @param maxBytesRead
	 * 		the maximum number of bytes read per period. A negative value means there is no limit.
	 * @param maxBytesWritten
	 * 		the maximum number of bytes written per period. A negative value means there is no limit.
	 */
	public Bandwidth(Period period, long maxBytesRead, long maxBytesWritten) {
		this.readBandwidthChecker = new BandwidthChecker(period, maxBytesRead);
		this.writeBandwidthChecker = new BandwidthChecker(period, maxBytesWritten);
	}

	/**
	 * Read bandwidth getter.
	 *
	 * @return the bandwidth checker.
	 */
	public BandwidthChecker getReadBandwidthChecker() {
		return this.readBandwidthChecker;
	}

	/**
	 * Write bandwidth getter.
	 *
	 * @return the bandwidth checker.
	 */
	public BandwidthChecker getWriteBandwidthChecker() {
		return this.writeBandwidthChecker;
	}

	@Override
	public String toString() {
		return "{ Download: " + this.readBandwidthChecker + ", Upload: " + this.writeBandwidthChecker + " }";  // $NON-NLS-1$
	}
}
