package java.util;

import ej.annotation.Nullable;

/**
 * The <code>Dictionary</code> class is the abstract parent of any class, such as
 * <code>Hashtable</code>, which maps keys to values. Every key and every value is an object. In any
 * one <code>Dictionary</code> object, every key is associated with at most one value. Given a
 * <code>Dictionary</code> and a key, the associated element can be looked up. Any non-<code>null</code>
 * object can be used as a key and as a value.
 * <p>
 * As a rule, the <code>equals</code> method should be used by implementations of this class to
 * decide if two keys are the same.
 * <p>
 * <strong>NOTE: This class is obsolete. New implementations should implement the Map interface,
 * rather than extending this class.</strong>
 *
 * @param <K>
 *        the type of the keys maintained by this dictionary
 * @param <V>
 *        the type of the mapped values
 *
 * @see java.util.Map
 * @see java.lang.Object#equals(java.lang.Object)
 * @see java.lang.Object#hashCode()
 * @see java.util.Hashtable
 */
public abstract class Dictionary<K, V> {
	/**
	 * Sole constructor. (For invocation by subclass constructors, typically implicit.)
	 */
	public Dictionary() {
	}

	/**
	 * Returns an enumeration of the values in this dictionary. The general contract for the
	 * <code>elements</code> method is that an <code>Enumeration</code> is returned that will generate all the
	 * elements contained in entries in this dictionary.
	 *
	 * @return an enumeration of the values in this dictionary.
	 * @see java.util.Dictionary#keys()
	 * @see java.util.Enumeration
	 */
	public abstract Enumeration<V> elements();

	/**
	 * Returns the value to which the key is mapped in this dictionary. The general contract for the
	 * <code>isEmpty</code> method is that if this dictionary contains an entry for the specified key, the
	 * associated value is returned; otherwise, <code>null</code> is returned.
	 *
	 * @return the value to which the key is mapped in this dictionary, or <code>null</code> if the key is
	 *         not mapped to any value in this dictionary.
	 * @param key
	 *        a key in this dictionary.
	 * @exception NullPointerException
	 *            if the <code>key</code> is <code>null</code>.
	 * @see java.util.Dictionary#put(java.lang.Object, java.lang.Object)
	 */
	@Nullable
	public abstract V get(Object key);

	/**
	 * Tests if this dictionary maps no keys to value. The general contract for the <code>isEmpty</code>
	 * method is that the result is true if and only if this dictionary contains no entries.
	 *
	 * @return <code>true</code> if this dictionary maps no keys to values; <code>false</code>
	 *         otherwise.
	 */
	public abstract boolean isEmpty();

	/**
	 * Returns an enumeration of the keys in this dictionary. The general contract for the keys method
	 * is that an <code>Enumeration</code> object is returned that will generate all the keys for which this
	 * dictionary contains entries.
	 *
	 * @return an enumeration of the keys in this dictionary.
	 * @see java.util.Dictionary#elements()
	 * @see java.util.Enumeration
	 */
	public abstract Enumeration<K> keys();

	/**
	 * Maps the specified <code>key</code> to the specified <code>value</code> in this dictionary.
	 * Neither the key nor the value can be <code>null</code>.
	 * <p>
	 * If this dictionary already contains an entry for the specified <code>key</code>, the value already in
	 * this dictionary for that <code>key</code> is returned, after modifying the entry to contain the new
	 * element.
	 * <p>
	 * If this dictionary does not already have an entry for the specified <code>key</code>, an entry is
	 * created for the specified <code>key</code> and <code>value</code>, and <code>null</code> is returned.
	 * <p>
	 * The <code>value</code> can be retrieved by calling the <code>get</code> method with a
	 * <code>key</code> that is equal to the original <code>key</code>.
	 *
	 * @param key
	 *        the hashtable key.
	 * @param value
	 *        the value.
	 * @return the previous value to which the <code>key</code> was mapped in this dictionary, or
	 *         <code>null</code> if the key did not have a previous mapping.
	 * @exception NullPointerException
	 *            if the <code>key</code> or <code>value</code> is <code>null</code>.
	 * @see java.lang.Object#equals(java.lang.Object)
	 * @see java.util.Dictionary#get(java.lang.Object)
	 */
	@Nullable
	public abstract V put(K key, V value);

	/**
	 * Removes the <code>key</code> (and its corresponding <code>value</code>) from this dictionary.
	 * This method does nothing if the <code>key</code> is not in this dictionary.
	 *
	 * @param key
	 *        the key that needs to be removed.
	 * @return the value to which the <code>key</code> had been mapped in this dictionary, or
	 *         <code>null</code> if the key did not have a mapping.
	 * @exception NullPointerException
	 *            if <code>key</code> is <code>null</code>.
	 */
	@Nullable
	public abstract V remove(Object key);

	/**
	 * Returns the number of entries (distinct keys) in this dictionary.
	 *
	 * @return the number of keys in this dictionary.
	 */
	public abstract int size();

}
