/*
 * Java
 *
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.tools;

import ej.annotation.Nullable;

public class BasicQueue<T> {

	private Object[] array;
	private int headIndex;
	private int tailIndex;

	public BasicQueue() {
		this.array = new Object[0];
		this.headIndex = -1;
		this.tailIndex = -1;
	}

	public void resize(int size) {
		this.array = new Object[size];
		this.headIndex = -1;
		this.tailIndex = 0;
	}

	public boolean push(Object element) {
		if (this.tailIndex == this.headIndex) {
			return false; // full
		} else {
			if (this.headIndex == -1) { // empty
				this.headIndex = this.tailIndex;
			}
			this.array[this.tailIndex] = element;
			this.tailIndex = incrementIndex(this.tailIndex);
			return true;
		}
	}

	public @Nullable T pop() {
		if (this.headIndex == -1) { // empty
			return null;
		} else {
			@SuppressWarnings("unchecked")
			T element = (T) this.array[this.headIndex];
			this.array[this.headIndex] = null; // help GC
			this.headIndex = incrementIndex(this.headIndex);
			if (this.headIndex == this.tailIndex) { // empty
				this.headIndex = -1;
			}
			return element;
		}
	}

	public void clear() {
		if (this.headIndex != -1) { // not empty
			this.headIndex = -1;
			this.tailIndex = 0;

			for (int i = 0; i < this.array.length; i++) {
				this.array[i] = null; // help GC
			}
		}
	}

	private int incrementIndex(int index) {
		if (index + 1 < this.array.length) {
			return index + 1;
		} else {
			return 0;
		}
	}
}
