/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.audio;

/**
 * {@link RuntimeException} thrown when an error occurred during an audio operation.
 */
public class AudioException extends RuntimeException {

	/** Error when trying to open a stream but the audio device is not available. */
	public static final int UNAVAILABLE_DEVICE = -1;

	/** Error when trying to open a stream but the format is not supported. */
	public static final int UNSUPPORTED_FORMAT = -2;

	/** Error when trying to open a stream but there is not enough memory. */
	public static final int OUT_OF_MEMORY = -3;

	/** Error when trying to open a stream but it cannot be open for an implementation-specific reason. */
	public static final int UNSPECIFIED_OPEN_ERROR = -4;

	private static final long serialVersionUID = -6970630047434666569L;

	/**
	 * Creates an audio exception with the specified error code.
	 *
	 * @param errorCode
	 *            the error code.
	 */
	public AudioException(int errorCode) {
		throw new RuntimeException();
	}

	/**
	 * Creates an audio exception with the specified error code and cause.
	 *
	 * @param errorCode
	 *            the error code.
	 * @param cause
	 *            the cause.
	 */
	public AudioException(int errorCode, Throwable cause) {
		throw new RuntimeException();
	}

	/**
	 * Returns the error code of this audio exception.
	 *
	 * @return the error code.
	 */
	public int getErrorCode() {
		throw new RuntimeException();
	}
}
