/*
 * Java
 *
 * Copyright 2016-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.ecom.wifi;

import ej.annotation.Nullable;

/**
 * Software enabled Access Point (SoftAP) configuration. A SoftAP is often referred to as a virtual router. A SoftAP
 * aims at creating an access point that will expose a wireless network that clients can join.
 */
public class SoftAPConfiguration {

	/**
	 * Gets SoftAP name.
	 *
	 * @return SoftAP name or <code>null</code> if not set.
	 */
	@Nullable
	public String getName() {
		throw new RuntimeException();
	}

	/**
	 * Gets SoftAP passphrase.
	 *
	 * @return SoftAP passphrase or <code>null</code> if not set.
	 */
	@Nullable
	public String getPassphrase() {
		throw new RuntimeException();
	}

	/**
	 * Gets SoftAP security mode.
	 *
	 * @return SoftAP security mode or <code>null</code> if not set.
	 */
	@Nullable
	public SecurityMode getSecurityMode() {
		throw new RuntimeException();
	}

	/**
	 * Gets SoftAP SSID.
	 *
	 * @return SoftAP SSID or <code>null</code> if not set.
	 */
	@Nullable
	public String getSSID() {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP name.
	 *
	 * @param name
	 *            SoftAP name or <code>null</code>.
	 */
	public void setName(@Nullable String name) {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP passphrase.
	 *
	 * @param passphrase
	 *            SoftAP passphrase or <code>null</code>.
	 */
	public void setPassphrase(@Nullable String passphrase) {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP security mode.
	 *
	 * @param securityMode
	 *            SoftAP security mode or <code>null</code>.
	 */
	public void setSecurityMode(@Nullable SecurityMode securityMode) {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP SSID.
	 *
	 * @param ssid
	 *            SoftAP SSID or <code>null</code>.
	 */
	public void setSSID(@Nullable String ssid) {
		throw new RuntimeException();
	}

}
