/*
 * Java
 *
 * Copyright 2012-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.event.generator;

import ej.microui.event.EventGenerator;

/**
 * A states event generator is usually associated to a group of physical devices holding a position (switch, rotary
 * wheel encoder, ...) and allows to generate events relating to them. This class generates {@link #EVENT_TYPE} events
 * and allows to retrieve for each state its current value. Each instance can manage at most <code>256</code> states and
 * each state can have a value between <code>0</code> and <code>255</code>.<br>
 * A state has a unique identifier between <code>0</code> and <code>{@link #getNumberOfStates()}-1</code>
 */
public class States extends EventGenerator {

	/**
	 * The STATE event type returned by {@link #getEventType()}.
	 */
	public static final int EVENT_TYPE = 0x03;

	/**
	 * Gets the state's identifier held by the state event.
	 *
	 * @param event
	 *            the state event to decode.
	 *
	 * @return id between <code>0</code> and <code>255</code>.
	 */
	public static int getStateId(int event) {
		throw new RuntimeException();
	}

	/**
	 * Gets the state's value held by the state event.
	 *
	 * @param event
	 *            the state event to decode.
	 *
	 * @return value between <code>0</code> and <code>255</code>.
	 */
	public static int getStateValue(int event) {
		throw new RuntimeException();
	}

	/**
	 * Creates a states generator.
	 *
	 * @param nbValues
	 *            number of values for each state.
	 * @param initialValues
	 *            initial value for each state.
	 * @throws IllegalArgumentException
	 *             if both arrays don't have the same length.
	 * @throws IndexOutOfBoundsException
	 *             if arrays length is greater than 255.
	 * @throws IndexOutOfBoundsException
	 *             if <code>nbValues[i] &lt; 0</code> or <code>nbValues[i] &gt; 255</code>.
	 * @throws IndexOutOfBoundsException
	 *             if <code>initialValues[i] &lt; 0</code> or <code>initialValues[i] &gt;= nbValues[i]</code>.
	 */
	public States(int[] nbValues, int[] initialValues) {
		throw new RuntimeException();
	}

	/**
	 * Gets the event type associated with the event generator. Default value is {@link #EVENT_TYPE}.
	 *
	 * @return the event type.
	 */

	@Override
	public int getEventType() {
		throw new RuntimeException();
	}

	/**
	 * Gets the total number of values for the given state.
	 *
	 * @param stateId
	 *            the state identifier value.
	 * @return the total number of values for the given state.
	 *
	 * @throws IndexOutOfBoundsException
	 *             when stateId is out of <code>[0,{@link #getNumberOfStates()}-1]</code>.
	 */
	public int getNumberOfValues(int stateId) {
		throw new RuntimeException();
	}

	/**
	 * Gets the current value of the given state.
	 *
	 * @param stateId
	 *            the state identifier value.
	 * @return a number between <code>0</code> and <code>{@link #getNumberOfValues(int)}-1</code>.
	 * @throws IndexOutOfBoundsException
	 *             when stateId is out of <code>[0,{@link #getNumberOfStates()}-1]</code>.
	 */
	public int getCurrentValue(int stateId) {
		throw new RuntimeException();
	}

	/**
	 * Gets the number of states managed by this instance.
	 *
	 * @return the number of states managed by this instance.
	 */
	public int getNumberOfStates() {
		throw new RuntimeException();
	}

	/**
	 * Builds a MicroUI event for the given state identifier on its value.
	 *
	 * @param stateId
	 *            the state identifier value.
	 * @param value
	 *            the new state value
	 * @return the MicroUI event
	 */
	public int buildEvent(int stateId, int value) {
		throw new RuntimeException();
	}

	/**
	 * Stores the given state value and sends a MicroUI {@link #EVENT_TYPE} to the States's listener.
	 *
	 * @param stateId
	 *            the state identifier value.
	 * @param value
	 *            the new state value
	 * @throws IndexOutOfBoundsException
	 *             when <code>stateId</code> is out of <code>[0,{@link #getNumberOfStates()}-1]</code>.
	 * @throws IndexOutOfBoundsException
	 *             when <code>value</code> is out of <code>[0,{@link #getNumberOfValues(int)}-1]</code>.
	 */
	public void send(int stateId, int value) {
		throw new RuntimeException();
	}
}
