/*
 * Copyright (c) 1996, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2017 IS2T. This file has been modified by IS2T S.A.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - All Rights Reserved
 *
 *   The original version of this source code and documentation is copyrighted
 * and owned by Taligent, Inc., a wholly-owned subsidiary of IBM. These
 * materials are provided under terms of a License Agreement between Taligent
 * and Sun. This technology is protected by multiple US and International
 * patents. This notice and attribution to Taligent may not be removed.
 *   Taligent is a registered trademark of Taligent, Inc.
 *
 */

package java.text;

import java.io.Serializable;

import ej.util.text.EnglishDateFormatSymbols;

/**
 * <code>DateFormatSymbols</code> is a public class for encapsulating localizable date-time formatting data, such as the
 * names of the months, the names of the days of the week, and the time zone data. <code>DateFormat</code> and
 * <code>SimpleDateFormat</code> both use <code>DateFormatSymbols</code> to encapsulate this information.
 *
 *
 * <p>
 *
 * @see DateFormat
 * @see SimpleDateFormat
 * @author Chen-Lieh Huang
 */
public class DateFormatSymbols implements Serializable, Cloneable {

	private static DateFormatSymbols CachedInstance;
	/* use serialVersionUID from JDK 1.1.4 for interoperability */
	static final long serialVersionUID = -5987973545549424702L;

	/**
	 * Era strings. For example: "AD" and "BC". An array of 2 strings, indexed by <code>Calendar.BC</code> and
	 * <code>Calendar.AD</code>.
	 *
	 * @serial
	 */
	String[] eras = null;

	/**
	 * Month strings. For example: "January", "February", etc. An array of 13 strings (some calendars have 13 months),
	 * indexed by <code>Calendar.JANUARY</code>, <code>Calendar.FEBRUARY</code>, etc.
	 *
	 * @serial
	 */
	String[] months = null;

	/**
	 * Short month strings. For example: "Jan", "Feb", etc. An array of 13 strings (some calendars have 13 months),
	 * indexed by <code>Calendar.JANUARY</code>, <code>Calendar.FEBRUARY</code>, etc.
	 *
	 * @serial
	 */
	String[] shortMonths = null;

	/**
	 * Weekday strings. For example: "Sunday", "Monday", etc. An array of 8 strings, indexed by
	 * <code>Calendar.SUNDAY</code>, <code>Calendar.MONDAY</code>, etc. The element <code>weekdays[0]</code> is ignored.
	 *
	 * @serial
	 */
	String[] weekdays = null;

	/**
	 * Short weekday strings. For example: "Sun", "Mon", etc. An array of 8 strings, indexed by
	 * <code>Calendar.SUNDAY</code>, <code>Calendar.MONDAY</code>, etc. The element <code>shortWeekdays[0]</code> is
	 * ignored.
	 *
	 * @serial
	 */
	String[] shortWeekdays = null;

	/**
	 * AM and PM strings. For example: "AM" and "PM". An array of 2 strings, indexed by <code>Calendar.AM</code> and
	 * <code>Calendar.PM</code>.
	 *
	 * @serial
	 */
	String[] ampms = null;

	// /**
	// * Localized names of time zones in this locale. This is a two-dimensional array of strings of size <em>n</em> by
	// * <em>m</em>, where <em>m</em> is at least 5. Each of the <em>n</em> rows is an entry containing the localized
	// * names for a single <code>TimeZone</code>. Each such row contains (with <code>i</code> ranging from
	// 0..<em>n</em>
	// * -1):
	// * <ul>
	// * <li><code>zoneStrings[i][0]</code> - time zone ID</li>
	// * <li><code>zoneStrings[i][1]</code> - long name of zone in standard time</li>
	// * <li><code>zoneStrings[i][2]</code> - short name of zone in standard time</li>
	// * <li><code>zoneStrings[i][3]</code> - long name of zone in daylight saving time</li>
	// * <li><code>zoneStrings[i][4]</code> - short name of zone in daylight saving time</li>
	// * </ul>
	// * The zone ID is <em>not</em> localized; it's one of the valid IDs of the {@link java.util.TimeZone TimeZone}
	// class
	// * that are not <a href="../java/util/TimeZone.html#CustomID">custom IDs</a>. All other entries are localized
	// names.
	// *
	// * @see java.util.TimeZone
	// * @serial
	// */
	// String zoneStrings[][] = null;

	/**
	 * Construct a DateFormatSymbols.
	 *
	 * @see #getInstance()
	 */
	public DateFormatSymbols() {
	}

	/**
	 * Gets the <code>DateFormatSymbols</code> instance in English. .
	 *
	 * @return a <code>DateFormatSymbols</code> instance.
	 * @since 1.6
	 */
	public static final DateFormatSymbols getInstance() {
		if (CachedInstance == null) {
			CachedInstance = new EnglishDateFormatSymbols();
		}
		return CachedInstance;
	}

	/**
	 * Gets era strings. For example: "AD" and "BC".
	 *
	 * @return the era strings.
	 */
	public String[] getEras() {
		return this.eras;
	}

	/**
	 * Gets era strings. For example: "AD" and "BC".
	 *
	 * @param i
	 *            the number of the era.
	 *
	 * @return the era strings.
	 */
	public String getEra(int i) {
		return this.eras[i];
	}

	/**
	 * Sets era strings. For example: "AD" and "BC".
	 *
	 * @param newEras
	 *            the new era strings.
	 */
	public void setEras(final String[] newEras) {
		if (newEras != null) {
			this.eras = newEras.clone();
		} else {
			this.eras = null;
		}
	}

	/**
	 * Gets month strings. For example: "January", "February", etc.
	 *
	 * @return the month strings.
	 */
	public String[] getMonths() {
		return this.months;
	}

	/**
	 * Gets month strings. For example: "January", "February", etc.
	 *
	 * @param i
	 *            the number of the month.
	 *
	 * @return the month strings.
	 */
	public String getMonth(int i) {
		return this.months[i];
	}

	/**
	 * Sets month strings. For example: "January", "February", etc.
	 *
	 * @param newMonths
	 *            the new month strings.
	 */
	public void setMonths(final String[] newMonths) {
		if (newMonths != null) {
			this.months = newMonths.clone();
		} else {
			this.months = null;
		}
	}

	/**
	 * Gets short month strings. For example: "Jan", "Feb", etc.
	 *
	 * @return the short month strings.
	 */
	public String[] getShortMonths() {
		return this.shortMonths;
	}

	/**
	 * Gets short month strings. For example: "Jan", "Feb", etc.
	 *
	 * @param i
	 *            the number of the month.
	 *
	 * @return the short month strings.
	 */
	public String getShortMonth(int i) {
		return this.shortMonths[i];
	}

	/**
	 * Sets short month strings. For example: "Jan", "Feb", etc.
	 *
	 * @param newShortMonths
	 *            the new short month strings.
	 */
	public void setShortMonths(final String[] newShortMonths) {
		if (newShortMonths != null) {
			this.shortMonths = newShortMonths.clone();
		} else {
			this.shortMonths = null;
		}
	}

	/**
	 * Gets weekday strings. For example: "Sunday", "Monday", etc.
	 *
	 * @return the weekday strings. Use <code>Calendar.SUNDAY</code>, <code>Calendar.MONDAY</code>, etc. to index the
	 *         result array.
	 */
	public String[] getWeekdays() {
		return this.weekdays;
	}

	/**
	 * Gets weekday strings. For example: "Sunday", "Monday", etc.
	 *
	 * @param i
	 *            the number of the weekday.
	 *
	 * @return the weekday strings. Use <code>Calendar.SUNDAY</code>, <code>Calendar.MONDAY</code>, etc. to index the
	 *         result array.
	 */
	public String getWeekday(int i) {
		return this.weekdays[i];
	}

	/**
	 * Sets weekday strings. For example: "Sunday", "Monday", etc.
	 *
	 * @param newWeekdays
	 *            the new weekday strings. The array should be indexed by <code>Calendar.SUNDAY</code>,
	 *            <code>Calendar.MONDAY</code>, etc.
	 */
	public void setWeekdays(final String[] newWeekdays) {
		if (newWeekdays != null) {
			this.weekdays = newWeekdays.clone();
		} else {
			this.weekdays = null;
		}
	}

	/**
	 * Gets short weekday strings. For example: "Sun", "Mon", etc.
	 *
	 * @return the short weekday strings. Use <code>Calendar.SUNDAY</code>, <code>Calendar.MONDAY</code>, etc. to index
	 *         the result array.
	 */
	public String[] getShortWeekdays() {
		return this.shortWeekdays;
	}

	/**
	 * Gets short weekday strings. For example: "Sun", "Mon", etc.
	 *
	 * @param i
	 *            the number of the weekday.
	 *
	 * @return the short weekday strings. Use <code>Calendar.SUNDAY</code>, <code>Calendar.MONDAY</code>, etc. to index
	 *         the result array.
	 */
	public String getShortWeekday(int i) {
		return this.shortWeekdays[i];
	}

	/**
	 * Sets short weekday strings. For example: "Sun", "Mon", etc.
	 *
	 * @param newShortWeekdays
	 *            the new short weekday strings. The array should be indexed by <code>Calendar.SUNDAY</code>,
	 *            <code>Calendar.MONDAY</code>, etc.
	 */
	public void setShortWeekdays(final String[] newShortWeekdays) {
		if (newShortWeekdays != null) {
			this.shortWeekdays = newShortWeekdays.clone();
		} else {
			this.shortWeekdays = null;
		}
	}

	/**
	 * Gets ampm strings. For example: "AM" and "PM".
	 *
	 * @return the ampm strings.
	 */
	public String[] getAmPmStrings() {
		return this.ampms;
	}

	/**
	 * Gets ampm strings. For example: "AM" and "PM".
	 *
	 * @param i
	 *            the number of the am/pm
	 *
	 * @return the ampm strings.
	 */
	public String getAmPmString(int i) {
		return this.ampms[i];
	}

	/**
	 * Sets ampm strings. For example: "AM" and "PM".
	 *
	 * @param newAmpms
	 *            the new ampm strings.
	 */
	public void setAmPmStrings(final String[] newAmpms) {
		if (newAmpms != null) {
			this.ampms = newAmpms.clone();
		} else {
			this.ampms = null;
		}
	}

	// /**
	// * Gets time zone strings. Use of this method is discouraged; use {@link java.util.TimeZone#getDisplayName()
	// * TimeZone.getDisplayName()} instead.
	// * <p>
	// * The value returned is a two-dimensional array of strings of size <em>n</em> by <em>m</em>, where <em>m</em> is
	// at
	// * least 5. Each of the <em>n</em> rows is an entry containing the localized names for a single
	// * <code>TimeZone</code>. Each such row contains (with <code>i</code> ranging from 0..<em>n</em>-1):
	// * <ul>
	// * <li><code>zoneStrings[i][0]</code> - time zone ID</li>
	// * <li><code>zoneStrings[i][1]</code> - long name of zone in standard time</li>
	// * <li><code>zoneStrings[i][2]</code> - short name of zone in standard time</li>
	// * <li><code>zoneStrings[i][3]</code> - long name of zone in daylight saving time</li>
	// * <li><code>zoneStrings[i][4]</code> - short name of zone in daylight saving time</li>
	// * </ul>
	// * The zone ID is <em>not</em> localized; it's one of the valid IDs of the {@link java.util.TimeZone TimeZone}
	// class
	// * that are not <a href="../util/TimeZone.html#CustomID">custom IDs</a>. All other entries are localized names. If
	// a
	// * zone does not implement daylight saving time, the daylight saving time names should not be used.
	// * <p>
	// * If {@link #setZoneStrings(String[][]) setZoneStrings} has been called on this <code>DateFormatSymbols</code>
	// * instance, then the strings provided by that call are returned. Otherwise, the returned array contains names
	// * provided by the Java runtime and by installed {@link java.util.spi.TimeZoneNameProvider TimeZoneNameProvider}
	// * implementations.
	// *
	// * @return the time zone strings.
	// * @see #setZoneStrings(String[][])
	// */
	// public String[][] getZoneStrings() {
	// return this.zoneStrings;
	// }
	//
	// /**
	// * Sets time zone strings. The argument must be a two-dimensional array of strings of size <em>n</em> by
	// <em>m</em>,
	// * where <em>m</em> is at least 5. Each of the <em>n</em> rows is an entry containing the localized names for a
	// * single <code>TimeZone</code>. Each such row contains (with <code>i</code> ranging from 0..<em>n</em>-1):
	// * <ul>
	// * <li><code>zoneStrings[i][0]</code> - time zone ID</li>
	// * <li><code>zoneStrings[i][1]</code> - long name of zone in standard time</li>
	// * <li><code>zoneStrings[i][2]</code> - short name of zone in standard time</li>
	// * <li><code>zoneStrings[i][3]</code> - long name of zone in daylight saving time</li>
	// * <li><code>zoneStrings[i][4]</code> - short name of zone in daylight saving time</li>
	// * </ul>
	// * The zone ID is <em>not</em> localized; it's one of the valid IDs of the {@link java.util.TimeZone TimeZone}
	// class
	// * that are not <a href="../util/TimeZone.html#CustomID">custom IDs</a>. All other entries are localized names.
	// *
	// * @param newZoneStrings
	// * the new time zone strings.
	// * @exception IllegalArgumentException
	// * if the length of any row in <code>newZoneStrings</code> is less than 5
	// * @exception NullPointerException
	// * if <code>newZoneStrings</code> is null
	// * @see #getZoneStrings()
	// */
	// public void setZoneStrings(String[][] newZoneStrings) {
	// this.zoneStrings = newZoneStrings;
	// }
}
