/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.impl;

import ej.rcommand.CommandSender;
import ej.rcommand.RemoteCommandListener;
import ej.rcommand.RemoteCommandManager;

/**
 * A {@link RemoteCommandManager} that dispatches all the unknown command to the {@link CommandSender}.
 */
public class GatewayRemoteCommandManager extends DefaultRemoteCommandManager{

	private CommandDispatchService dispatchService;
	
	public GatewayRemoteCommandManager(boolean overwrite){
		super(overwrite);
		initDispatchService();
	}
	
	public GatewayRemoteCommandManager(){
		super();
		initDispatchService();
	}
	
	private void initDispatchService() {
		this.dispatchService = new CommandDispatchService();
		dispatchService.initialize(this);
	}

	@Override
	protected RemoteCommandListener getListenerFor(String command) {
		RemoteCommandListener listener = super.getListenerFor(command);
		if(listener == null){
			listener = dispatchService;
		}
		return listener;
	}
	
}
