/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.impl;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.RemoteConnection;

/**
 * Service that receives commands from a connection and dispatch them into other connections.<br>
 * This service relies on internal implementation and should not be used by the application (a
 * cast is done in the #{@link CommandDispatchService} method).
 */
/*default*/ class CommandDispatchService extends AbstractRemoteService {

	@Override
	public void commandReceived(CommandReader commandReader, CommandSender commandSender, String command) {
		getLogger().info("Dispatch command " + command);
		try {
			// force cast… until a better solution is found
			RemoteConnection remoteConnection = (RemoteConnection) commandReader;
			List<Object> params = remoteConnection.readParameters();
			synchronized (commandSenderProvider) {
				for (CommandSender commandSerializer : this.commandSenderProvider.getCommandSenders(command)) {
					if (commandSerializer == commandReader) {
						continue;// don't dispatch the command to the input connection
					}
					RemoteConnection outputConnection = (RemoteConnection) commandSerializer;
					outputConnection.startCommand(command);
					outputConnection.sendParams(params);
					outputConnection.flushCommand();
				}
			}
		} catch (IOException e) {
			getLogger().log(Level.SEVERE, e.getMessage(), e);
		}
	}

	private Logger getLogger() {
		return Logger.getLogger(CommandDispatchService.class.getName());
	}
	
	@Override
	public String[] getManagedCommands() {
		return new String[0];
	}
}
