/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

import java.util.Collection;

/**
 * Provides a list of active connections.
 */
public interface CommandSenderProvider {

	/**
	 * Returns the command senders that handle the given command.<p>
	 * Synchronize on this {@link CommandSenderProvider} while using the 
	 * returned collection to avoid concurrent modifications of the collection.
	 */
	Collection<? extends CommandSender> getCommandSenders(String command);

	/**
	 * Registers a listener that will be called when command managed by the listener is read.
	 *
	 * @param listener
	 *            the listener to register
	 * @throws IllegalStateException
	 *             if a listener is already registered for a command managed by the listener
	 */
	void registerListener(RemoteCommandListener listener) throws IllegalStateException;

}
