/*
 * Copyright 2020-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.soar;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * The SOAR Optimizer (aka <code>SOAR-O</code>) public API for building Features. <br>
 * The SOAR Optimizer allows to build Feature (<code>.fo</code> files) for the very Kernel on which it is executed. Then
 * the <code>.fo</code> file can be dynamically linked using <code>ej.kf.Kernel.install(InputStream)</code>.
 *
 * The Kernel metadata content is loaded and cached <i>on demand</i>. The more a Feature adheres to a Kernel (i.e.
 * depends on various Kernel APIs types, methods and fields), the more this instance will allocate and cache Kernel
 * metadata objects in Java heap.
 */
public class FeatureOptimizer {

	/**
	 * Creates a new {@link FeatureOptimizer} instance with the given Kernel metadata provider.
	 * <p>
	 * It loads the Kernel metadata header and checks whether it corresponds to the Kernel on which this method is
	 * actually executed.
	 *
	 *
	 * @param kernelMetadataProvider
	 *            the Kernel metadata provider.
	 * @throws FeatureOptimizerException
	 *             if the Kernel metadata cannot be loaded.
	 */
	public FeatureOptimizer(KernelMetadataProvider kernelMetadataProvider) throws FeatureOptimizerException {
		throw new RuntimeException();
	}

	/**
	 * Builds a Feature (<code>.fo</code> file) for this Kernel from a shared Feature (<code>.fso</code> file).
	 * <p>
	 * This methods blocks until the Feature <code>.fo</code> file is fully generated and flushed to the given output
	 * stream. An error may be thrown while the output stream is partially written.
	 *
	 * @param fsoFile
	 *            the input stream for the loaded shared Feature (<code>.fso</code> file).
	 *
	 * @param foFile
	 *            the output stream for the generated Feature (<code>.fo</code> file).
	 *
	 * @throws FeatureOptimizerException
	 *             if the Feature cannot be built on this Kernel.
	 */
	public void build(InputStream fsoFile, OutputStream foFile) throws FeatureOptimizerException {
		throw new RuntimeException();
	}

	/**
	 * Gets the Kernel UID of the loaded Kernel metadata.
	 *
	 * @return the Kernel UID of the loaded Kernel metadata.
	 */
	public byte[] getKernelUID() {
		throw new RuntimeException();
	}
}
