package java.util;

/**
 * This class provides a skeletal implementation of the <code>Collection</code> interface, to minimize
 * the effort required to implement this interface.
 * <p>
 *
 * To implement an unmodifiable collection, the programmer needs only to extend this class and
 * provide implementations for the <code>iterator</code> and <code>size</code> methods. (The iterator
 * returned by the <code>iterator</code> method must implement <code>hasNext</code> and <code>next</code>.)
 * <p>
 *
 * To implement a modifiable collection, the programmer must additionally override this class's
 * <code>add</code> method (which otherwise throws an <code>UnsupportedOperationException</code>), and the
 * iterator returned by the <code>iterator</code> method must additionally implement its <code>remove</code>
 * method.
 * <p>
 *
 * The programmer should generally provide a void (no argument) and <code>Collection</code> constructor,
 * as per the recommendation in the <code>Collection</code> interface specification.
 * <p>
 *
 * The documentation for each non-abstract method in this class describes its implementation in
 * detail. Each of these methods may be overridden if the collection being implemented admits a more
 * efficient implementation.
 * <p>
 *
 * This class is a member of the Java Collections Framework. 
 * 
 * @param <E> the type of the elements in this collection
 */

public abstract class AbstractCollection<E> implements Collection<E> {
	/**
	 * Sole constructor. (For invocation by subclass constructors, typically implicit.)
	 */
	protected AbstractCollection() {
	}

	/**
	 * Ensures that this collection contains the specified element (optional operation). Returns
	 * <code>true</code> if this collection changed as a result of the call. (Returns <code>false</code> if this
	 * collection does not permit duplicates and already contains the specified element.)
	 * <p>
	 *
	 * Collections that support this operation may place limitations on what elements may be added to
	 * this collection. In particular, some collections will refuse to add <code>null</code> elements, and
	 * others will impose restrictions on the type of elements that may be added. Collection classes
	 * should clearly specify in their documentation any restrictions on what elements may be added.
	 * <p>
	 *
	 * If a collection refuses to add a particular element for any reason other than that it already
	 * contains the element, it <i>must</i> throw an exception (rather than returning <code>false</code> ).
	 * This preserves the invariant that a collection always contains the specified element after this
	 * call returns.
	 *
	 * <p>
	 * This implementation always throws an <code>UnsupportedOperationException</code>.
	 *
	 * @param e
	 *        element whose presence in this collection is to be ensured
	 * @return <code>true</code> if this collection changed as a result of the call
	 * @throws UnsupportedOperationException
	 *         if the <code>add</code> operation is not supported by this collection
	 * @throws ClassCastException
	 *         if the class of the specified element prevents it from being added to this collection
	 * @throws NullPointerException
	 *         if the specified element is null and this collection does not permit null elements
	 * @throws IllegalArgumentException
	 *         if some property of the element prevents it from being added to this collection
	 * @throws IllegalStateException
	 *         if the element cannot be added at this time due to insertion restrictions
	 */
	@Override
	public boolean add(E e) {
		throw new RuntimeException();
	}

	/**
	 * Adds all of the elements in the specified collection to this collection (optional operation). The
	 * behavior of this operation is undefined if the specified collection is modified while the
	 * operation is in progress. (This implies that the behavior of this call is undefined if the
	 * specified collection is this collection, and this collection is nonempty.)
	 *
	 * <p>
	 * This implementation iterates over the specified collection, and adds each object returned by the
	 * iterator to this collection, in turn.
	 *
	 * <p>
	 * Note that this implementation will throw an <code>UnsupportedOperationException</code> unless
	 * <code>add</code> is overridden (assuming the specified collection is non-empty).
	 *
	 * @param c
	 *        collection containing elements to be added to this collection
	 * @return <code>true</code> if this collection changed as a result of the call
	 * @throws UnsupportedOperationException
	 *         if the <code>addAll</code> operation is not supported by this collection
	 * @throws ClassCastException
	 *         if the class of an element of the specified collection prevents it from being added to
	 *         this collection
	 * @throws NullPointerException
	 *         if the specified collection contains a null element and this collection does not permit
	 *         null elements, or if the specified collection is null
	 * @throws IllegalArgumentException
	 *         if some property of an element of the specified collection prevents it from being added
	 *         to this collection
	 * @throws IllegalStateException
	 *         if not all the elements can be added at this time due to insertion restrictions
	 *
	 * @see #add(Object)
	 */
	@Override
	public boolean addAll(Collection<? extends E> c) {
		throw new RuntimeException();
	}

	/**
	 * Removes all of the elements from this collection (optional operation). The collection will be
	 * empty after this method returns.
	 *
	 * <p>
	 * This implementation iterates over this collection, removing each element using the
	 * <code>Iterator.remove</code> operation. Most implementations will probably choose to override this
	 * method for efficiency.
	 *
	 * <p>
	 * Note that this implementation will throw an <code>UnsupportedOperationException</code> if the
	 * iterator returned by this collection's <code>iterator</code> method does not implement the
	 * <code>remove</code> method and this collection is non-empty.
	 *
	 * @throws UnsupportedOperationException
	 *         if the <code>clear</code> operation is not supported by this collection
	 */
	@Override
	public void clear() {
		throw new RuntimeException();
	}

	/**
	 * Returns <code>true</code> if this collection contains the specified element. More formally, returns
	 * <code>true</code> if and only if this collection contains at least one element <code>e</code> such that
	 * <code>(o==null&nbsp;?&nbsp;e==null&nbsp;:&nbsp;o.equals(e))</code>.
	 *
	 * <p>
	 * This implementation iterates over the elements in the collection, checking each element in turn
	 * for equality with the specified element.
	 *
	 * @param o
	 *        element whose presence in this collection is to be tested
	 * @return <code>true</code> if this collection contains the specified element
	 * @throws ClassCastException
	 *         if the type of the specified element is incompatible with this collection
	 *         (<a href="#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if the specified element is null and this collection does not permit null elements
	 *         (<a href="#optional-restrictions">optional</a>)
	 */
	@Override
	public boolean contains(Object o) {
		throw new RuntimeException();
	}

	/**
	 * Adds all of the elements in the specified collection to this collection (optional operation). The
	 * behavior of this operation is undefined if the specified collection is modified while the
	 * operation is in progress. (This implies that the behavior of this call is undefined if the
	 * specified collection is this collection, and this collection is nonempty.)
	 *
	 * <p>
	 * This implementation iterates over the specified collection, checking each element returned by the
	 * iterator in turn to see if it's contained in this collection. If all elements are so contained
	 * <code>true</code> is returned, otherwise <code>false</code>.
	 *
	 * @param c
	 *        collection containing elements to be added to this collection
	 * @return <code>true</code> if this collection changed as a result of the call
	 * @throws UnsupportedOperationException
	 *         if the <code>addAll</code> operation is not supported by this collection
	 * @throws ClassCastException
	 *         if the class of an element of the specified collection prevents it from being added to
	 *         this collection
	 * @throws NullPointerException
	 *         if the specified collection contains a null element and this collection does not permit
	 *         null elements, or if the specified collection is null
	 * @throws IllegalArgumentException
	 *         if some property of an element of the specified collection prevents it from being added
	 *         to this collection
	 * @throws IllegalStateException
	 *         if not all the elements can be added at this time due to insertion restrictions
	 *
	 * @see #contains(Object)
	 */
	@Override
	public boolean containsAll(Collection<?> c) {
		throw new RuntimeException();
	}

	/**
	 * Returns <code>true</code> if this collection contains no elements.
	 *
	 * <p>
	 * This implementation returns <code>size() == 0</code>.
	 *
	 * @return <code>true</code> if this collection contains no elements
	 */
	@Override
	public boolean isEmpty() {
		throw new RuntimeException();
	}

	/**
	 * Returns an iterator over the elements in this collection. There are no guarantees concerning the
	 * order in which the elements are returned (unless this collection is an instance of some class
	 * that provides a guarantee).
	 *
	 * @return an <code>Iterator</code> over the elements in this collection
	 */
	@Override
	public abstract Iterator<E> iterator();

	/**
	 * Removes a single instance of the specified element from this collection, if it is present
	 * (optional operation). More formally, removes an element <code>e</code> such that
	 * <code>(o==null&nbsp;?&nbsp;e==null&nbsp;:&nbsp;o.equals(e))</code>, if this collection contains one
	 * or more such elements. Returns <code>true</code> if this collection contained the specified element
	 * (or equivalently, if this collection changed as a result of the call).
	 *
	 * <p>
	 * This implementation iterates over the collection looking for the specified element. If it finds
	 * the element, it removes the element from the collection using the iterator's remove method.
	 *
	 * <p>
	 * Note that this implementation throws an <code>UnsupportedOperationException</code> if the iterator
	 * returned by this collection's iterator method does not implement the <code>remove</code> method and
	 * this collection contains the specified object.
	 *
	 * @param o
	 *        element to be removed from this collection, if present
	 * @return <code>true</code> if an element was removed as a result of this call
	 * @throws ClassCastException
	 *         if the type of the specified element is incompatible with this collection
	 *         (<a href="#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if the specified element is null and this collection does not permit null elements
	 *         (<a href="#optional-restrictions">optional</a>)
	 * @throws UnsupportedOperationException
	 *         if the <code>remove</code> operation is not supported by this collection
	 */
	@Override
	public boolean remove(Object o) {
		throw new RuntimeException();
	}

	/**
	 * Removes all of this collection's elements that are also contained in the specified collection
	 * (optional operation). After this call returns, this collection will contain no elements in common
	 * with the specified collection.
	 *
	 * <p>
	 * This implementation iterates over this collection, checking each element returned by the iterator
	 * in turn to see if it's contained in the specified collection. If it's so contained, it's removed
	 * from this collection with the iterator's <code>remove</code> method.
	 *
	 * <p>
	 * Note that this implementation will throw an <code>UnsupportedOperationException</code> if the
	 * iterator returned by the <code>iterator</code> method does not implement the <code>remove</code> method
	 * and this collection contains one or more elements in common with the specified collection.
	 *
	 * @param c
	 *        collection containing elements to be removed from this collection
	 * @return <code>true</code> if this collection changed as a result of the call
	 * @throws UnsupportedOperationException
	 *         if the <code>removeAll</code> method is not supported by this collection
	 * @throws ClassCastException
	 *         if the types of one or more elements in this collection are incompatible with the
	 *         specified collection (<a href="#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if this collection contains one or more null elements and the specified collection does
	 *         not support null elements (<a href="#optional-restrictions">optional</a>), or if the
	 *         specified collection is null
	 *
	 * @see #remove(Object)
	 * @see #contains(Object)
	 */
	@Override
	public boolean removeAll(Collection<?> c) {
		throw new RuntimeException();
	}

	/**
	 * Retains only the elements in this collection that are contained in the specified collection
	 * (optional operation). In other words, removes from this collection all of its elements that are
	 * not contained in the specified collection.
	 *
	 * <p>
	 * This implementation iterates over this collection, checking each element returned by the iterator
	 * in turn to see if it's contained in the specified collection. If it's not so contained, it's
	 * removed from this collection with the iterator's <code>remove</code> method.
	 *
	 * <p>
	 * Note that this implementation will throw an <code>UnsupportedOperationException</code> if the
	 * iterator returned by the <code>iterator</code> method does not implement the <code>remove</code> method
	 * and this collection contains one or more elements not present in the specified collection.
	 *
	 * @param c
	 *        collection containing elements to be retained in this collection
	 * @return <code>true</code> if this collection changed as a result of the call
	 * @throws UnsupportedOperationException
	 *         if the <code>retainAll</code> operation is not supported by this collection
	 * @throws ClassCastException
	 *         if the types of one or more elements in this collection are incompatible with the
	 *         specified collection (<a href="#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if this collection contains one or more null elements and the specified collection does
	 *         not permit null elements (<a href="#optional-restrictions">optional</a>), or if the
	 *         specified collection is null
	 *
	 * @see #remove(Object)
	 * @see #contains(Object)
	 */
	@Override
	public boolean retainAll(Collection<?> c) {
		throw new RuntimeException();
	}

	/**
	 * Returns the number of elements in this collection. If this collection contains more than
	 * <code>Integer.MAX_VALUE</code> elements, returns <code>Integer.MAX_VALUE</code>.
	 *
	 * @return the number of elements in this collection
	 */
	@Override
	public abstract int size();

	/**
	 * Returns an array containing all of the elements in this collection. If this collection makes any
	 * guarantees as to what order its elements are returned by its iterator, this method must return
	 * the elements in the same order.
	 *
	 * <p>
	 * The returned array will be "safe" in that no references to it are maintained by this collection.
	 * (In other words, this method must allocate a new array even if this collection is backed by an
	 * array). The caller is thus free to modify the returned array.
	 *
	 * <p>
	 * This method acts as bridge between array-based and collection-based APIs.
	 *
	 * <p>
	 * This implementation returns an array containing all the elements returned by this collection's
	 * iterator, in the same order, stored in consecutive elements of the array, starting with index
	 * {@code 0}. The length of the returned array is equal to the number of elements returned by the
	 * iterator, even if the size of this collection changes during iteration, as might happen if the
	 * collection permits concurrent modification during iteration. The {@code size} method is called
	 * only as an optimization hint; the correct result is returned even if the iterator returns a
	 * different number of elements.
	 *
	 * <p>
	 * This method is equivalent to:
	 *
	 * <pre>
	 * {
	 * 	&#064;code
	 * 	List&lt;E&gt; list = new ArrayList&lt;E&gt;(size());
	 * 	for (E e : this)
	 * 		list.add(e);
	 * 	return list.toArray();
	 * }
	 * </pre>
	 *
	 * @return an array containing all of the elements in this collection
	 */
	@Override
	public Object[] toArray() {
		throw new RuntimeException();
	}

	/**
	 * Returns an array containing all of the elements in this collection; the runtime type of the
	 * returned array is that of the specified array. If the collection fits in the specified array, it
	 * is returned therein. Otherwise, a new array is allocated with the runtime type of the specified
	 * array and the size of this collection.
	 *
	 * <p>
	 * If this collection fits in the specified array with room to spare (i.e., the array has more
	 * elements than this collection), the element in the array immediately following the end of the
	 * collection is set to <code>null</code>. (This is useful in determining the length of this collection
	 * <i>only</i> if the caller knows that this collection does not contain any <code>null</code>
	 * elements.)
	 *
	 * <p>
	 * If this collection makes any guarantees as to what order its elements are returned by its
	 * iterator, this method must return the elements in the same order.
	 *
	 * <p>
	 * Like the {@link #toArray()} method, this method acts as bridge between array-based and
	 * collection-based APIs. Further, this method allows precise control over the runtime type of the
	 * output array, and may, under certain circumstances, be used to save allocation costs.
	 *
	 * <p>
	 * Suppose <code>x</code> is a collection known to contain only strings. The following code can be used
	 * to dump the collection into a newly allocated array of <code>String</code>:
	 *
	 * <pre>
	 * String[] y = x.toArray(new String[0]);
	 * </pre>
	 *
	 * Note that <code>toArray(new Object[0])</code> is identical in function to <code>toArray()</code>.
	 *
	 * <p>
	 * This implementation returns an array containing all the elements returned by this collection's
	 * iterator in the same order, stored in consecutive elements of the array, starting with index
	 * {@code 0}. If the number of elements returned by the iterator is too large to fit into the
	 * specified array, then the elements are returned in a newly allocated array with length equal to
	 * the number of elements returned by the iterator, even if the size of this collection changes
	 * during iteration, as might happen if the collection permits concurrent modification during
	 * iteration. The {@code size} method is called only as an optimization hint; the correct result is
	 * returned even if the iterator returns a different number of elements.
	 *
	 * <p>
	 * This method is equivalent to:
	 *
	 * <pre>
	 * {
	 * 	&#064;code
	 * 	List&lt;E&gt; list = new ArrayList&lt;E&gt;(size());
	 * 	for (E e : this)
	 * 		list.add(e);
	 * 	return list.toArray(a);
	 * }
	 * </pre>
	 *
	 * @param a
	 *        the array into which the elements of this collection are to be stored, if it is big
	 *        enough; otherwise, a new array of the same runtime type is allocated for this purpose.
	 * @return an array containing all of the elements in this collection
	 * @throws ArrayStoreException
	 *         if the runtime type of the specified array is not a supertype of the runtime type of
	 *         every element in this collection
	 * @throws NullPointerException
	 *         if the specified array is null
	 */
	@Override
	public <T> T[] toArray(T[] a) {
		throw new RuntimeException();
	}

	/**
	 * Returns a string representation of this collection. The string representation consists of a list
	 * of the collection's elements in the order they are returned by its iterator, enclosed in square
	 * brackets (<code>"[]"</code>). Adjacent elements are separated by the characters <code>", "</code> (comma
	 * and space). Elements are converted to strings as by {@link String#valueOf(Object)}.
	 *
	 * @return a string representation of this collection
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

}
