package java.lang;

import ej.annotation.Nullable;

/**
 * Thrown to indicate that an assertion has failed.
 *
 * <p>
 * The seven one-argument public constructors provided by this class ensure that the assertion error
 * returned by the invocation:
 *
 * <pre>
 *     new AssertionError(<i>expression</i>)
 * </pre>
 *
 * has as its detail message the <i>string conversion</i> of <i>expression</i> (as defined in
 * section 15.18.1.1 of <cite>The Java&trade; Language Specification</cite>), regardless of the type
 * of <i>expression</i>.
 *
 */
public class AssertionError extends Error {

	/**
	 * Constructs an AssertionError with no detail message.
	 */
	public AssertionError() {
		throw new RuntimeException();
	}

	/**
	 * Constructs an AssertionError with its detail message derived from the specified
	 * <code>boolean</code>, which is converted to a string as defined in section 15.18.1.1 of <cite>The
	 * Java&trade; Language Specification</cite>.
	 *
	 * @param detailMessage
	 *        value to be used in constructing detail message
	 */
	public AssertionError(boolean detailMessage) {
		throw new RuntimeException();
	}

	/**
	 * Constructs an AssertionError with its detail message derived from the specified
	 * <code>char</code>, which is converted to a string as defined in section 15.18.1.1 of <cite>The
	 * Java&trade; Language Specification</cite>.
	 *
	 * @param detailMessage
	 *        value to be used in constructing detail message
	 */
	public AssertionError(char detailMessage) {
		throw new RuntimeException();
	}

	/**
	 * Constructs an AssertionError with its detail message derived from the specified
	 * <code>double</code>, which is converted to a string as defined in section 15.18.1.1 of <cite>The
	 * Java&trade; Language Specification</cite>.
	 *
	 * @param detailMessage
	 *        value to be used in constructing detail message
	 */
	public AssertionError(double detailMessage) {
		throw new RuntimeException();
	}

	/**
	 * Constructs an AssertionError with its detail message derived from the specified
	 * <code>float</code>, which is converted to a string as defined in section 15.18.1.1 of <cite>The
	 * Java&trade; Language Specification</cite>.
	 *
	 * @param detailMessage
	 *        value to be used in constructing detail message
	 */
	public AssertionError(float detailMessage) {
		throw new RuntimeException();
	}

	/**
	 * Constructs an AssertionError with its detail message derived from the specified <code>int</code>,
	 * which is converted to a string as defined in section 15.18.1.1 of <cite>The Java&trade; Language
	 * Specification</cite>.
	 *
	 * @param detailMessage
	 *        value to be used in constructing detail message
	 */
	public AssertionError(int detailMessage) {
		throw new RuntimeException();
	}

	/**
	 * Constructs an AssertionError with its detail message derived from the specified
	 * <code>long</code>, which is converted to a string as defined in section 15.18.1.1 of <cite>The
	 * Java&trade; Language Specification</cite>.
	 *
	 * @param detailMessage
	 *        value to be used in constructing detail message
	 */
	public AssertionError(long detailMessage) {
		throw new RuntimeException();
	}

	/**
	 * Constructs an AssertionError with its detail message derived from the specified object, which is
	 * converted to a string as defined in section 15.18.1.1 of <cite>The Java&trade; Language
	 * Specification</cite>.
	 * <p>
	 * If the specified object is an instance of {@code Throwable}, it becomes the <i>cause</i> of the
	 * newly constructed assertion error.
	 *
	 * @param detailMessage
	 *        value to be used in constructing detail message
	 * @see Throwable#getCause()
	 */
	public AssertionError(Object detailMessage) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@code AssertionError} with the specified detail message and cause.
	 *
	 * <p>
	 * Note that the detail message associated with {@code cause} is <i>not</i> automatically
	 * incorporated in this error's detail message.
	 *
	 * @param message
	 *        the detail message, may be {@code null}
	 * @param cause
	 *        the cause, may be {@code null}
	 */
	public AssertionError(String message, @Nullable Throwable cause) {
		throw new RuntimeException();
	}
}
