/*
 * Java
 *
 * Copyright 2011-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

import java.util.Hashtable;
import java.util.NoSuchElementException;

/**
 * <p>
 * This class gives access to the global immutable objects pool.
 * </p>
 * <p>
 * Immutable objects are persistent and normally reside in read-only-memory, such as flash memory.
 * </p>
 * <p>
 * Immutable objects are created in two ways:
 * </p>
 * <ul>
 * <li>at runtime by calling {@link #put(String, Object)} or {@link #putAll(Hashtable)},</li>
 * <li>at system/application configuration time by specifying objects in an XML configuration file.</li>
 * </ul>
 * <p>
 * The method {@link #get(String)} allows to retrieve an object from the pool using its ID.<br>
 * </p>
 */
public class Immutables {

	/**
	 * <p>
	 * Retrieves the object that match the the given ID in the immutable objects pool.
	 * </p>
	 * <p>
	 * If no object can be found with such ID, a {@link NoSuchElementException} is thrown.<br>
	 * </p>
	 *
	 * @param ID
	 *            the ID of the immutable object to get
	 * @return the immutable object matching the ID
	 * @throws NoSuchElementException
	 *            if the ID is not found
	 * @throws ImmutablesError
	 * 			  if an internal error occurred during immutable access
	 */
	public static Object get(String ID){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Maps the given ID to the given object in the immutable objects pool.
	 * </p>
	 * <p>
	 * The object can be retrieved by calling the get method with an ID that is equal to the original ID.
	 * </p>
	 *
	 * @param ID
	 *            the ID of the immutable object to set
	 * @param object
	 *            the object to set immutable
	 * @throws NullPointerException
	 *             if given object is <code>null</code>
	 * @throws OutOfMemoryError
	 *             if the immutable memory is full
	 * @see #freeMemory()
	 */
	public static void put(String ID, Object object){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Maps all the mappings in the given table in the immutable objects pool.
	 * </p>
	 *
	 * @param table
	 *            the table that contains the objects to set immutable
	 * @throws NullPointerException
	 *             if given table is <code>null</code>
	 * @throws ClassCastException
	 *             if an ID is not a {@link String}
	 * @throws OutOfMemoryError
	 *             if the immutable memory is full
	 * @see #freeMemory()
	 * @see #put(String, Object)
	 */
	public static void putAll(Hashtable table) {
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Gets whether or not the given object is in the immutable objects pool or not.
	 * </p>
	 *
	 * @param object
	 *            the object to check
	 * @return <code>true</code> if the given object is immutable, <code>false</code> otherwise
	 * @throws NullPointerException
	 *             if given object is <code>null</code>
	 */
	public static boolean isImmutable(Object object){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Returns an array with the IDs of all the objects in the pool.
	 * </p>
	 *
	 * @return all the immutable objects ID.
	 * @see #get(String)
	 */
	public static String[] allIDs(){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Returns the amount of free immutable memory still available.
	 * </p>
	 *
	 * @return the amount of free immutable memory
	 */
	public static long freeMemory(){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Returns the total amount of immutable memory.
	 * </p>
	 * <p>
	 * Note that the amount of memory required to hold an object of any given type may be implementation-dependent.
	 * </p>
	 *
	 * @return the total amount of immutable memory
	 */
	public static long totalMemory(){
		throw new RuntimeException();
	}

}