/*
 * Copyright (c) 2000, 2010, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2018-2021 MicroEJ Corp. EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javax.security.auth.x500;

import java.io.InputStream;
import java.security.Principal;

import ej.annotation.Nullable;

/**
 * <p>
 * This class represents an X.500 <code>Principal</code>. <code>X500Principal</code>s are represented by distinguished
 * names such as "CN=Duke, OU=JavaSoft, O=Sun Microsystems, C=US".
 *
 * <p>
 * This class can be instantiated by using a string representation of the distinguished name, or by using the ASN.1 DER
 * encoded byte representation of the distinguished name. The current specification for the string representation of a
 * distinguished name is defined in <a href="http://www.ietf.org/rfc/rfc2253.txt">RFC 2253: Lightweight Directory Access
 * Protocol (v3): UTF-8 String Representation of Distinguished Names</a>. This class, however, accepts string formats
 * from both RFC 2253 and <a href="http://www.ietf.org/rfc/rfc1779.txt">RFC 1779: A String Representation of
 * Distinguished Names</a>, and also recognizes attribute type keywords whose OIDs (Object Identifiers) are defined in
 * <a href="http://www.ietf.org/rfc/rfc3280.txt">RFC 3280: Internet X.509 Public Key Infrastructure Certificate and CRL
 * Profile</a>.
 *
 * <p>
 * The string representation for this <code>X500Principal</code> can be obtained by calling the <code>getName</code>
 * methods.
 *
 * <p>
 * Note that the <code>getSubjectX500Principal</code> and <code>getIssuerX500Principal</code> methods of
 * <code>X509Certificate</code> return X500Principals representing the issuer and subject fields of the certificate.
 *
 * @see java.security.cert.X509Certificate
 * @since 1.4
 */
public final class X500Principal implements Principal, java.io.Serializable {

	private static final long serialVersionUID = -500463348111345721L;

	/**
	 * Creates an <code>X500Principal</code> from a distinguished name in ASN.1 DER encoded form. The ASN.1 notation for
	 * this structure is as follows.
	 *
	 * <pre>
	 * <code>
	 * Name ::= CHOICE {
	 *   RDNSequence }
	 *
	 * RDNSequence ::= SEQUENCE OF RelativeDistinguishedName
	 *
	 * RelativeDistinguishedName ::=
	 *   SET SIZE (1 .. MAX) OF AttributeTypeAndValue
	 *
	 * AttributeTypeAndValue ::= SEQUENCE {
	 *   type     AttributeType,
	 *   value    AttributeValue }
	 *
	 * AttributeType ::= OBJECT IDENTIFIER
	 *
	 * AttributeValue ::= ANY DEFINED BY AttributeType
	 * ....
	 * DirectoryString ::= CHOICE {
	 *       teletexString           TeletexString (SIZE (1..MAX)),
	 *       printableString         PrintableString (SIZE (1..MAX)),
	 *       universalString         UniversalString (SIZE (1..MAX)),
	 *       utf8String              UTF8String (SIZE (1.. MAX)),
	 *       bmpString               BMPString (SIZE (1..MAX)) }
	 * </code>
	 * </pre>
	 *
	 * @param name
	 *            a byte array containing the distinguished name in ASN.1 DER encoded form
	 * @throws IllegalArgumentException
	 *             if an encoding error occurs (incorrect form for DN)
	 */
	public X500Principal(byte[] name) {
		throw new RuntimeException();
	}

	/**
	 * Creates an <code>X500Principal</code> from an <code>InputStream</code> containing the distinguished name in ASN.1
	 * DER encoded form. The ASN.1 notation for this structure is supplied in the documentation for
	 * {@link #X500Principal(byte[] name) X500Principal(byte[] name)}.
	 *
	 * <p>
	 * The read position of the input stream is positioned to the next available byte after the encoded distinguished
	 * name.
	 *
	 * @param is
	 *            an <code>InputStream</code> containing the distinguished name in ASN.1 DER encoded form
	 *
	 * @exception NullPointerException
	 *                if the <code>InputStream</code> is <code>null</code>
	 * @exception IllegalArgumentException
	 *                if an encoding error occurs (incorrect form for DN)
	 */
	public X500Principal(InputStream is) {
		throw new RuntimeException();
	}

	/**
	 * Returns a string representation of the X.500 distinguished name.
	 *
	 * <p>
	 * The chosen format is a '#' character followed by the hexadecimal encoding of de DER representation of the name.
	 * (No spaces between digits, letters in lower case).
	 *
	 * @return the distinguished name of this <code>X500Principal</code>
	 */
	public String getName() {
		throw new RuntimeException();
	}

	/**
	 * Return a user-friendly string representation of this <code>X500Principal</code>.
	 *
	 * In MicroEJ's implementation, the chosen format is RFC.
	 *
	 * @return a string representation of this <code>X500Principal</code>
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

	/**
	 * Compares the specified <code>Object</code> with this <code>X500Principal</code> for equality.
	 *
	 * <p>
	 * Specifically, this method returns <code>true</code> if the <code>Object</code> <i>o</i> is an
	 * <code>X500Principal</code> and if the respective canonical string representations (obtained via the
	 * <code>getName(X500Principal.CANONICAL)</code> method) of this object and <i>o</i> are equal.
	 *
	 * <p>
	 * This implementation is compliant with the requirements of RFC 3280.
	 *
	 * @param o
	 *            Object to be compared for equality with this <code>X500Principal</code>
	 *
	 * @return <code>true</code> if the specified <code>Object</code> is equal to this <code>X500Principal</code>,
	 *         <code>false</code> otherwise
	 */
	@Override
	public boolean equals(@Nullable Object o) {
		throw new RuntimeException();
	}

	/**
	 * Return a hash code for this <code>X500Principal</code>.
	 *
	 * <p>
	 * The hash code is calculated via: <code>getName(X500Principal.CANONICAL).hashCode()</code>
	 *
	 * @return a hash code for this <code>X500Principal</code>
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}
}
