/*
 * Java
 *
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.display;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class is for font permissions.
 * <p>
 * The name is related to the font APIs and it symbolizes the permission's action.
 * <p>
 * The meaning of the possible permissions is defined as follows:
 * <dl>
 * <dt>add
 * <dd>add permission. Permission is checked when fonts are added to the system during the initialization process.
 * </dl>
 *
 * @see java.security.Permission
 *
 * @since 2.0
 */
public class FontPermission extends Permission {

	/**
	 * @deprecated use {@link #FontPermission(String)}
	 */
	@Deprecated
	public FontPermission() {
		super(null);
		throw new RuntimeException();
	}

	/**
	 * Creates a permission with the specified name.
	 *
	 * @param permission
	 *            the name of the <code>FontPermission</code>.
	 */
	public FontPermission(String permission) {
		super(permission);
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
