package java.lang.annotation;

/**
 * A program element type. The constants of this enumerated type provide a simple classification of
 * the declared elements in a Java program.
 * 
 * <p>
 * These constants are used with the {@link Target} meta-annotation type to specify where it is
 * legal to use an annotation type.
 * 
 */
public enum ElementType {
	/** Annotation type declaration */
	ANNOTATION_TYPE,

	/** Constructor declaration */
	CONSTRUCTOR,

	/** Field declaration (includes enum constants) */
	FIELD,

	/** Local variable declaration */
	LOCAL_VARIABLE,

	/** Method declaration */
	METHOD,

	/** Package declaration */
	PACKAGE,

	/** Parameter declaration */
	PARAMETER,

	/** Class, interface (including annotation type), or enum declaration */
	TYPE
}
