/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.image.pathdata;

import ej.microvg.image.ImageGenerator.Format;

/**
 * Encodes a path with 16-bit values: the commands and the commands' attributes are encoded with 16-bit signed values.
 */
public class SingleArrayPathDataS16 extends SingleArrayPathData {

	@Override
	public Format getFormat() {
		return Format.VG_S16;
	}

	@Override
	public void appendCommand(int command) {
		append((short) command);
	}

	@Override
	public void appendCoordinate(double coordinate) {
		append((short) coordinate);
	}

	private void append(short i) {
		write((byte) (i));
		write((byte) (i >> 8));
	}

}
