/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion.none;

import ej.motion.Motion;
import ej.motion.MotionManager;
import ej.motion.util.TossHelper;

/**
 * Motion manager creating no motions.
 */
public class NoMotionManager implements MotionManager {

	@Override
	public Motion easeIn(int start, int stop, long duration) {
		return move(start, stop);
	}

	@Override
	public Motion easeOut(int start, int stop, long duration) {
		return move(start, stop);
	}

	@Override
	public Motion easeInOut(int start, int stop, long duration) {
		return move(start, stop);
	}

	private Motion move(int start, int stop) {
		return new NoMotion(start, stop);
	}

	@Override
	public Motion toss(int start, int min, int max, float initialSpeed, long duration) {
		int stop = TossHelper.computeExpectedStop(start, initialSpeed, duration);
		return new NoMotion(start, stop);
	}

}
