/*
 * Copyright 2015-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.websocket;

/**
 * This is a more specific {@link WebSocketException} type. It is thrown during when the error is caused by the server (such as an invalid HTTP status
 * code during the opening handshake).
 *
 *
 *
 */
public class ServerException extends WebSocketException {

	private int httpStatusCode = 0;

	/**
	 * Serial Version UID.
	 */
	private static final long serialVersionUID = 6104834258602150240L;

	/**
	 * Create a new server exception.
	 *
	 * @param string
	 *            message to describe the error case
	 */
	public ServerException(String string) {
		super(string);
	}

	/**
	 *
	 */
	public ServerException() {
		super();
	}

	/**
	 * Get the the HTTP status code returned by the server.
	 *
	 * @return the status code ; 0 if the code could not be determined
	 */
	public int getHttpStatusCode() {
		return httpStatusCode;
	}

	/**
	 * Set the the HTTP status code returned by the server.
	 *
	 * @param httpStatusCode
	 *            the status code
	 */
	public void setHttpStatusCode(int httpStatusCode) {
		this.httpStatusCode = httpStatusCode;
	}

}
